/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.python;

import commvault.tools.python.ExecutionResults;
import commvault.tools.python.PythonException;
import commvault.tools.python.RuntimeExecutor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PythonUtil {
    public static final String TAG_FUNCTION = "function";
    public static final String TAG_CLASS = "class";
    public static final String TAG_ARGUMENT = "arg";
    public static final String TAG_DATA = "data";
    public static final String TAG_PICKLE = "pickle";
    public static final String TAG_ITEM = "item";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";

    public static String formatPython(String string, Object[] objectArray) throws IOException {
        Object[] objectArray2 = PythonUtil.convertJavaArguments(objectArray);
        return String.format(string, objectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionResults executePython(String string) throws Exception {
        ExecutionResults executionResults;
        block4: {
            executionResults = new ExecutionResults();
            String string2 = UUID.randomUUID().toString();
            File file = new File(PythonUtil.getBaseDirectory() + string2 + ".py");
            File file2 = new File(PythonUtil.getBaseDirectory() + string2 + ".out");
            PythonUtil.writeFile(file, string);
            try {
                String string3 = "python.exe " + file.getAbsolutePath();
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(string3);
                int n = process.waitFor();
                if (n == 0) {
                    PythonUtil.populateResults(executionResults, file2);
                    break block4;
                }
                throw new PythonException(PythonUtil.parsePythonError(PythonUtil.streamToString(process.getErrorStream())));
            }
            finally {
                file.delete();
                file2.delete();
            }
        }
        return executionResults;
    }

    public static Document executeXml(File file, String string, long l) throws Exception {
        String string2 = UUID.randomUUID().toString();
        File file2 = new File(PythonUtil.getBaseDirectory() + string2 + ".py");
        File file3 = new File(PythonUtil.getBaseDirectory() + string2 + ".out");
        PythonUtil.writeFile(file2, string);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("python.exe", file2.getAbsolutePath());
            String string3 = file.getAbsolutePath();
            if (file.getParent() != null) {
                string3 = string3 + ";" + file.getParent();
            }
            processBuilder.environment().put("PYTHONPATH", string3);
            RuntimeExecutor runtimeExecutor = new RuntimeExecutor();
            int n = runtimeExecutor.execute(processBuilder, l);
            if (n == 0) {
                if (file3.exists()) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(file3);
                    return document;
                }
                throw new PythonException("missing xml file");
            }
            throw new PythonException(PythonUtil.parsePythonError(runtimeExecutor.getError()));
        }
        finally {
            file2.delete();
            file3.delete();
        }
    }

    public static void populateResults(ExecutionResults executionResults, File file) throws ParserConfigurationException, SAXException, IOException, PythonException {
        if (!file.exists()) {
            throw new PythonException("result file [" + file + "] does not exist");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        Element element = PythonUtil.getFirstElementChild(document.getDocumentElement());
        executionResults.returnValue = element.getNodeValue();
        executionResults.returnObject = PythonUtil.parseValueElement(element);
    }

    public static Object parseValueElement(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getAttribute(ATTRIBUTE_TYPE);
        List<Element> list = PythonUtil.getChildElements(element);
        if (list.size() > 0) {
            if (string.equalsIgnoreCase("dict") || string.equalsIgnoreCase("instance")) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (Element element2 : list) {
                    Element element3 = PythonUtil.getFirstElementByName(element2, TAG_KEY);
                    Element element4 = PythonUtil.getFirstElementByName(element2, TAG_VALUE);
                    hashMap.put(PythonUtil.parseValueElement(element3), PythonUtil.parseValueElement(element4));
                }
                return hashMap;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Element element5 : list) {
                arrayList.add(PythonUtil.parseValueElement(element5));
            }
            return arrayList.toArray();
        }
        return PythonUtil.python2Java(element.getNodeValue(), string);
    }

    public static String getBaseDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith("\\")) {
            return string + "\\";
        }
        return string;
    }

    private static String[] convertJavaArguments(Object[] objectArray) throws IOException {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = PythonUtil.java2Python(objectArray[i]);
        }
        return stringArray;
    }

    public static void writeFile(String string, String string2) throws IOException {
        File file = new File(PythonUtil.getBaseDirectory() + string);
        file.delete();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        fileWriter.close();
    }

    public static String java2Python(Object object) throws IOException {
        if (object == null) {
            return "None";
        }
        if (object instanceof String) {
            return "\"" + PythonUtil.escapeString((String)object) + "\"";
        }
        if (object instanceof Character) {
            return "'" + PythonUtil.escapeString(((Character)object).toString()) + "'";
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return "True";
            }
            return "False";
        }
        if (object instanceof Collection) {
            return PythonUtil.java2Python(((Collection)object).toArray());
        }
        if (object.getClass().isArray()) {
            return PythonUtil.java2Python((Object[])object);
        }
        if (object instanceof Map) {
            return PythonUtil.java2Python((Map)object);
        }
        if (object instanceof Iterable) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = ((Iterable)object).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return PythonUtil.java2Python(((List)object).toArray());
        }
        return String.valueOf(object);
    }

    private static String java2Python(Object[] objectArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(PythonUtil.java2Python(objectArray[i]));
            if (i >= objectArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String java2Python(Map map) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(PythonUtil.java2Python(entry.getKey()));
            stringBuilder.append(":");
            stringBuilder.append(PythonUtil.java2Python(entry.getValue()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static Object python2Java(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string2.equals("bool")) {
            return Boolean.parseBoolean(string.toLowerCase());
        }
        if (string2.equals("string") || string2.equals("str") || string2.equals("unicode")) {
            return string;
        }
        if (string2.equals("int")) {
            return Integer.parseInt(string);
        }
        if (string2.equals("float")) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (string2.equals("short")) {
            return Short.parseShort(string);
        }
        if (string2.equals("long")) {
            return Long.parseLong(string);
        }
        if (string2.equals("double")) {
            return Double.parseDouble(string);
        }
        if (string2.equals("char")) {
            return Character.valueOf(string.charAt(0));
        }
        if (string2.equals("byte")) {
            return Byte.valueOf(string);
        }
        if (string2.equals("NoneType")) {
            return null;
        }
        System.err.println("Unknown python type [" + string2 + "], using String");
        return string;
    }

    public static String parsePythonError(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (string2.length() <= 0 || !(stringArray = string2.split(" "))[0].endsWith(":")) continue;
            return string2;
        }
        return string;
    }

    public static String streamToString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while (bufferedInputStream.available() != 0) {
            stringBuilder.append((char)bufferedInputStream.read());
        }
        return stringBuilder.toString().trim();
    }

    public static void writeFile(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static Element getFirstElementChild(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static String serializeElement(Element element) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(element), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Element getFirstElementByName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public static List<Element> getChildElements(Node node, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public static Class getJavaType(String string) {
        if (string == null) {
            return Object.class;
        }
        if ((string = string.trim()).length() == 0) {
            return Object.class;
        }
        if (string.equals("bool")) {
            return Boolean.class;
        }
        if (string.equals("string") || string.equals("str")) {
            return String.class;
        }
        if (string.equals("list")) {
            return Object.class;
        }
        if (string.equals("set")) {
            return Object.class;
        }
        if (string.equals("int")) {
            return Integer.class;
        }
        if (string.equals("float")) {
            return Float.class;
        }
        if (string.equals("byte")) {
            return Object.class;
        }
        if (string.equals("short")) {
            return Short.class;
        }
        if (string.equals("long")) {
            return Long.class;
        }
        if (string.equals("double")) {
            return Double.class;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("dict")) {
            return Object.class;
        }
        System.err.println("Unknown python type [" + string + "]");
        return Object.class;
    }

    public static String escapeString(String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        if (string == null) {
            return null;
        }
        int n = string.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                stringWriter.write("\\u" + PythonUtil.hex(c));
                continue;
            }
            if (c > '\u00ff') {
                stringWriter.write("\\u0" + PythonUtil.hex(c));
                continue;
            }
            if (c > '\u007f') {
                stringWriter.write("\\u00" + PythonUtil.hex(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringWriter.write(92);
                        stringWriter.write(98);
                        break;
                    }
                    case '\n': {
                        stringWriter.write(92);
                        stringWriter.write(110);
                        break;
                    }
                    case '\t': {
                        stringWriter.write(92);
                        stringWriter.write(116);
                        break;
                    }
                    case '\f': {
                        stringWriter.write(92);
                        stringWriter.write(102);
                        break;
                    }
                    case '\r': {
                        stringWriter.write(92);
                        stringWriter.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringWriter.write("\\u00" + PythonUtil.hex(c));
                            break;
                        }
                        stringWriter.write("\\u000" + PythonUtil.hex(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    stringWriter.write(39);
                    continue block13;
                }
                case '\"': {
                    stringWriter.write(92);
                    stringWriter.write(34);
                    continue block13;
                }
                case '\\': {
                    stringWriter.write(92);
                    stringWriter.write(92);
                    continue block13;
                }
                case '/': {
                    stringWriter.write(47);
                    continue block13;
                }
                default: {
                    stringWriter.write(c);
                }
            }
        }
        return stringWriter.toString();
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
    }
}

