/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.ClassDef;
import commvault.tools.generator.ConstantDef;
import commvault.tools.generator.FieldDef;
import commvault.tools.generator.Generator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NameSpace {
    public static Generator.Type type;
    public String name;
    public int id;
    public String packageName;
    private List<ClassDef> classes = new ArrayList<ClassDef>();
    private List<ConstantDef> constants = new ArrayList<ConstantDef>();
    private List<FieldDef> xPathFields = new ArrayList<FieldDef>();
    private List<NameSpace> includes = new ArrayList<NameSpace>();
    private List<AnnotationDefValues> annotations = new ArrayList<AnnotationDefValues>();
    public List<KeyValue> keyValues = new ArrayList<KeyValue>();
    public static final String SUBSYSTEM = "SubSystem";
    private boolean cppSubsystemExternalize = false;
    private String functionContentWithIn = new String();
    private static boolean isWindows;
    private boolean isGenerateXPathSeparate = false;
    private List<String> tabReferenceFileEntries = new ArrayList<String>();
    public static HashMap<String, String> valueMap;
    public String genMode = "NOCHECK";
    public String genCode = "ALL";
    private String functionContent = new String();
    List<String> parsed = new ArrayList<String>();
    static HashMap<String, String> xPathKeyMap;
    static HashMap<String, Integer> KeyValueMap;
    static int max;

    public boolean isGenerateXPathSeparate() {
        return this.isGenerateXPathSeparate;
    }

    public void setGenerateXPathSeparate(boolean bl) {
        this.isGenerateXPathSeparate = bl;
    }

    public boolean getIsWindows() {
        return isWindows;
    }

    public String getFunctionContentWithIn() {
        return this.functionContentWithIn;
    }

    public void setFunctionContentWithIn(String string) {
        this.functionContentWithIn = string;
    }

    public String getFunctionContent() {
        return this.functionContent;
    }

    public void setFunctionContent(String string) {
        this.functionContent = string;
    }

    public List<KeyValue> getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(List<KeyValue> list) {
        this.keyValues = list;
    }

    public String getName() {
        return this.name;
    }

    public Properties getConfig() {
        return Generator.config;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<ClassDef> getAllClasses() {
        ClassDef classDef = new ClassDef(this.name + SUBSYSTEM, false, this);
        classDef.getAnnotations().addAll(this.annotations);
        ArrayList<ClassDef> arrayList = new ArrayList<ClassDef>(this.classes);
        arrayList.add(classDef);
        return arrayList;
    }

    public List<ClassDef> getClasses() {
        return this.classes;
    }

    public void setClasses(List<ClassDef> list) {
        this.classes = list;
    }

    public int getId() {
        return this.id;
    }

    public List<NameSpace> getIncludes() {
        return this.includes;
    }

    public void addInclude(NameSpace nameSpace) {
        this.includes.add(nameSpace);
    }

    public List<ConstantDef> getConstants() {
        return this.constants;
    }

    public void preProcessConstants() {
        for (ConstantDef constantDef : this.constants) {
            constantDef.preProcess();
        }
    }

    public List<FieldDef> getDotXPathFields() {
        return this.xPathFields;
    }

    /*
     * WARNING - void declaration
     */
    public List<XPath> getXpaths() {
        void var4_10;
        ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
        for (FieldDef arrayList3 : this.xPathFields) {
            List<TreePath> list = this.getTreePaths(arrayList3.getClassDef());
            arrayList2.addAll(this.appendToPaths(arrayList3, list));
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (TreePath treePath : arrayList2) {
            this.appendNode(defaultMutableTreeNode, treePath, 0);
        }
        ArrayList<XPath> arrayList = new ArrayList<XPath>();
        boolean bl = false;
        while (var4_10 < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt((int)var4_10);
            this.addXPath(arrayList, defaultMutableTreeNode2, null);
            ++var4_10;
        }
        return arrayList;
    }

    public List<XPath> getVectorXpaths() {
        ArrayList<XPath> arrayList = new ArrayList<XPath>();
        for (XPath xPath : this.getXpaths()) {
            if (!xPath.getFieldDef().isList()) continue;
            arrayList.add(xPath);
        }
        return arrayList;
    }

    public List<XPath> getSingleInstancedXpaths() {
        ArrayList<XPath> arrayList = new ArrayList<XPath>();
        for (XPath xPath : this.getXpaths()) {
            if (!xPath.isSingleInstancedXPath()) continue;
            arrayList.add(xPath);
        }
        return arrayList;
    }

    public List<XPath> getSuppressMetaDataXPaths() {
        ArrayList<XPath> arrayList = new ArrayList<XPath>();
        for (XPath xPath : this.getXpaths()) {
            if (!xPath.isSuppressMetaDataXPath()) continue;
            arrayList.add(xPath);
        }
        return arrayList;
    }

    private void addXPath(ArrayList<XPath> arrayList, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode.isLeaf()) {
            arrayList.add(new XPath((TreePath)defaultMutableTreeNode.getUserObject(), string));
        } else if (defaultMutableTreeNode.getChildCount() == 1) {
            this.addXPath(arrayList, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0), string);
        } else {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.addXPath(arrayList, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), (String)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject());
            }
        }
    }

    private void appendNode(DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath, int n) {
        if (treePath.getPathCount() <= n) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(treePath));
            return;
        }
        FieldDef fieldDef = (FieldDef)treePath.getPathComponent(n);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode2.getUserObject().toString().equalsIgnoreCase(fieldDef.name)) continue;
            this.appendNode(defaultMutableTreeNode2, treePath, ++n);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(fieldDef.name);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.appendNode(defaultMutableTreeNode3, treePath, ++n);
    }

    private List<TreePath> getTreePaths(ClassDef classDef) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (FieldDef fieldDef : classDef.getAllFields()) {
            if (fieldDef.isPrimitive() || fieldDef.templateType != null) {
                TreePath treePath = new TreePath(fieldDef);
                arrayList.add(treePath);
                continue;
            }
            boolean bl = true;
            for (AnnotationDefValues annotationDefValues : fieldDef.getClassDef().getAnnotations()) {
                if (!annotationDefValues.getAnnotationDef().name.equals("ProcessingInstruction")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            List<TreePath> list = this.getTreePaths(fieldDef.isList() ? fieldDef.templateType : fieldDef.type);
            list = this.appendToPaths(fieldDef, list);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<TreePath> appendToPaths(FieldDef fieldDef, List<TreePath> list) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (TreePath treePath : list) {
            arrayList.add(treePath.pathByAddingChild(fieldDef));
        }
        list.clear();
        return arrayList;
    }

    public List<AnnotationDefValues> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDefValues> list) {
        this.annotations = list;
    }

    public boolean canParse(String string) {
        if (this.parsed.contains(string)) {
            return false;
        }
        this.parsed.add(string);
        return true;
    }

    public ClassDef findClassDef(String string) {
        for (ClassDef classDef : this.classes) {
            if (!classDef.name.equals(string)) continue;
            return classDef;
        }
        return null;
    }

    public List<ClassDef> getTopClasses() {
        ArrayList<ClassDef> arrayList = new ArrayList<ClassDef>();
        for (ClassDef classDef : this.getClasses()) {
            if (!classDef.topLevel) continue;
            arrayList.add(classDef);
        }
        return arrayList;
    }

    public boolean isCPPSubSystemExternalise() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Subsystem")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("externaliseCPPSubSystem")) continue;
                return annotationValue.getValue().equalsIgnoreCase(Boolean.TRUE.toString());
            }
        }
        return false;
    }

    public int getMaxXPathValue() {
        return max;
    }

    public static void loadXPathKeys(String string) {
        String string2;
        String string3;
        max = 0;
        Pattern pattern = Pattern.compile("#define\\s+(.*)_XPATH\\s+\"(.*)\"");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string3 = matcher.group(1);
            string2 = matcher.group(2);
            xPathKeyMap.put(string2, string3);
        }
        pattern = Pattern.compile("#define\\s+(.*)\\s+(\\d+)");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string3 = matcher.group(1);
            string2 = matcher.group(2);
            try {
                int n = Integer.parseInt(string2.trim());
                if (n > max && n < 100000) {
                    max = n;
                }
                KeyValueMap.put(string3, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setCppSubsystemExternalize(boolean bl) {
        this.cppSubsystemExternalize = bl;
    }

    public boolean getCppSubsystemExternalize() {
        return this.cppSubsystemExternalize;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setGenMode(String string) {
        this.genMode = string;
    }

    public String getGenMode() {
        return this.genMode;
    }

    public void setGenCode(String string) {
        this.genCode = string;
    }

    public String getGenCode() {
        return this.genCode;
    }

    public boolean rearrangeMessages() throws IOException {
        int n;
        Object object;
        Object object2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        boolean[] blArray = new boolean[this.classes.size()];
        ArrayList<ClassDef> arrayList = new ArrayList<ClassDef>();
        for (int i = 0; i < this.classes.size(); ++i) {
            ClassDef classDef = this.classes.get(i);
            hashMap.put(classDef.name, i);
        }
        ArrayList arrayList2 = new ArrayList(this.classes.size());
        for (int i = 0; i < this.classes.size(); ++i) {
            object2 = this.classes.get(i);
            hashMap.put(((ClassDef)object2).name, i);
            ArrayList arrayList3 = new ArrayList();
            arrayList2.add(i, arrayList3);
            for (FieldDef fieldDef : ((ClassDef)object2).getFields()) {
                if (fieldDef.isPrimitive()) continue;
                object = null;
                object = fieldDef.isList() ? (Integer)hashMap.get(fieldDef.templateType.name) : (Integer)hashMap.get(fieldDef.type.name);
                if (object == null) continue;
                ((List)arrayList2.get(i)).add(object);
            }
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        object2 = new Stack();
        for (n = 0; n < this.classes.size(); ++n) {
            Object object3;
            linkedList.add(n);
            boolean bl = false;
            while (linkedList.size() != 0) {
                object3 = (Integer)linkedList.remove();
                object = (List)arrayList2.get((Integer)object3);
                ((Stack)object2).push(object3);
                if (object.size() != 0) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Integer n2 = (Integer)iterator.next();
                        if (blArray[(Integer)object3]) continue;
                        if (n2 > (Integer)object3) {
                            linkedList.add(n2);
                        } else {
                            ((Stack)object2).push(n2);
                        }
                        bl = true;
                    }
                }
                if (blArray[(Integer)object3] || bl) continue;
                arrayList.add(this.classes.get((Integer)object3));
                blArray[((Integer)object3).intValue()] = true;
            }
            while (!((Stack)object2).empty()) {
                object3 = (Integer)((Stack)object2).pop();
                if (blArray[(Integer)object3]) continue;
                arrayList.add(this.classes.get((Integer)object3));
                blArray[((Integer)object3).intValue()] = true;
            }
        }
        n = this.classes.size();
        this.classes.clear();
        for (int i = 0; i < n; ++i) {
            this.classes.add((ClassDef)arrayList.get(i));
        }
        return false;
    }

    public void setTabReferenceFileEntries(List<String> list) {
        this.tabReferenceFileEntries = list;
    }

    public List<String> getTabReferenceFileEntries() {
        return this.tabReferenceFileEntries;
    }

    static {
        isWindows = true;
        valueMap = new HashMap<String, String>(){
            {
                this.put("Id", "ID");
            }
        };
        String string = System.getProperty("os.name");
        if (string != null && !string.startsWith("Win")) {
            isWindows = false;
        }
        xPathKeyMap = new HashMap();
        KeyValueMap = new HashMap();
        max = 0;
    }

    public static class KeyValue {
        private String key = null;
        private String value = null;

        public KeyValue() {
        }

        public KeyValue(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getMessageValue() {
            String[] stringArray = this.value.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!valueMap.containsKey(stringArray[i])) continue;
                stringArray[i] = valueMap.get(stringArray[i]);
            }
            String string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + " " + stringArray[i];
            }
            return string;
        }
    }

    public static class XPath {
        String xPath;
        FieldDef fieldDef;
        String key;

        public XPath(TreePath treePath, String string) {
            this.fieldDef = (FieldDef)treePath.getPathComponent(0);
            if (string == null) {
                this.key = ((FieldDef)treePath.getPathComponent((int)1)).type.name.toUpperCase() + "_" + this.fieldDef.getConstantName();
            } else {
                this.key = this.fieldDef.getConstantName();
                for (int i = 1; i < treePath.getPathCount(); ++i) {
                    FieldDef fieldDef = (FieldDef)treePath.getPathComponent(i);
                    this.key = fieldDef.name.toUpperCase() + "_" + this.key;
                    if (fieldDef.name.equalsIgnoreCase(string)) break;
                }
            }
            Object[] objectArray = treePath.getPath();
            this.xPath = "";
            for (int i = objectArray.length - 1; i >= 1; --i) {
                this.xPath = this.xPath + ((FieldDef)objectArray[i]).name + "[1]/";
            }
            this.xPath = this.fieldDef.isList() ? this.xPath + this.fieldDef.name : this.xPath + "@" + this.fieldDef.name;
            if (xPathKeyMap.containsKey(this.xPath)) {
                this.key = xPathKeyMap.get(this.xPath);
            }
        }

        public String getXpath() {
            return this.xPath;
        }

        public FieldDef getFieldDef() {
            return this.fieldDef;
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            int n = Math.abs(this.xPath.hashCode());
            List<AnnotationDefValues> list = this.fieldDef.getAnnotations();
            int n2 = 1;
            n2 <<= 31;
            for (AnnotationDefValues annotationDefValues : list) {
                if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("IndexAttr")) continue;
                for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                    if (!annotationValue.getField().name.equalsIgnoreCase("indexedMetadata") || !annotationValue.getValue().equalsIgnoreCase("true")) continue;
                    n = n2 | n;
                }
            }
            return n;
        }

        public boolean isSingleInstancedXPath() {
            List<AnnotationDefValues> list = this.fieldDef.getAnnotations();
            for (AnnotationDefValues annotationDefValues : list) {
                if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("SingleInstanced")) continue;
                return true;
            }
            return false;
        }

        public boolean isSuppressMetaDataXPath() {
            List<AnnotationDefValues> list = this.fieldDef.getAnnotations();
            for (AnnotationDefValues annotationDefValues : list) {
                if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("SuppressMetadata")) continue;
                return true;
            }
            return false;
        }
    }
}

