/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.Generator;
import commvault.tools.generator.NameSpace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

public class GenUtil {
    public static String getType(Class clazz) {
        if (NameSpace.type != Generator.Type.CPP) {
            return clazz.getSimpleName();
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (clazz.equals(String.class)) {
            return "string";
        }
        if (List.class.isAssignableFrom(clazz)) {
            return "vector";
        }
        return clazz.getSimpleName();
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Boolean.class) || clazz.equals(Long.class) || clazz.equals(Float.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        try {
            int n;
            int n2 = 0;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n);
                n2 += n;
            }
            writer.flush();
            int n3 = n2;
            return n3;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String getFileContent(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        GenUtil.copy(new FileReader(string), stringWriter);
        return stringWriter.toString();
    }

    public static String getAnnotation(List<AnnotationDefValues> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AnnotationDefValues annotationDefValues : list) {
            stringBuffer.append("@").append(annotationDefValues.getAnnotationDef().getName());
            if (annotationDefValues.getAnnotationFieldValues().size() <= 0) continue;
            stringBuffer.append("(");
            int n = 0;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(annotationValue.getField().getName()).append("=");
                stringBuffer.append(annotationValue.getField().isEnumType() ? annotationValue.getField().getType() + "." + annotationValue.getValue() : annotationValue.getValue());
                ++n;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static String getAnnotationCS(List<AnnotationDefValues> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AnnotationDefValues annotationDefValues : list) {
            stringBuffer.append("[").append(annotationDefValues.getAnnotationDef().getName());
            stringBuffer.append("Attribute");
            if (annotationDefValues.getAnnotationFieldValues().size() > 0) {
                stringBuffer.append("(");
                int n = 0;
                for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(annotationValue.getField().getName()).append("=");
                    stringBuffer.append(annotationValue.getField().isEnumType() ? annotationValue.getField().getType() + "." + annotationValue.getValue() : annotationValue.getValue());
                    ++n;
                }
                stringBuffer.append(")");
            }
            stringBuffer.append("]").append("\n");
        }
        return stringBuffer.toString();
    }

    public static void generateAddinResourceBundle(String string, String string2) throws Exception {
        string = string + "/commvault/i18n";
        File file = new File(string);
        Properties properties = new Properties();
        properties.load(new FileInputStream(string + "/MessagesBundle.addin"));
        for (File file2 : file.listFiles()) {
            String string3;
            if (!file2.getName().endsWith(".properties") || !file2.getName().startsWith("Message")) continue;
            System.out.println(file2);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            File file3 = new File(string2 + "/commvault/i18n/" + file2.getName());
            FileWriter fileWriter = new FileWriter(file3);
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                int n = string3.indexOf(61);
                if (n < 0 || !properties.containsKey((string4 = string3.substring(0, n)).trim())) continue;
                fileWriter.write(string3);
                fileWriter.write("\n");
                fileWriter.flush();
            }
        }
    }
}

