/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import java.util.ArrayList;
import java.util.List;

public class ConstantItem {
    String name;
    String id;
    List<ConstantItem> group = new ArrayList<ConstantItem>();
    List<ConstantItem> exceptGroup = new ArrayList<ConstantItem>();
    List<ConstantItem> constants = new ArrayList<ConstantItem>();
    boolean preProcessed = false;

    public List<ConstantItem> getGroup() {
        return this.group;
    }

    public List<ConstantItem> getExceptGroup() {
        return this.exceptGroup;
    }

    public List<ConstantItem> getAllConstants() {
        if (!this.preProcessed) {
            throw new NullPointerException("constats is not processed");
        }
        return this.constants;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isAppGroup() {
        return this.group.size() != 0;
    }

    public void preProcess(List<ConstantItem> list) {
        if (this.preProcessed) {
            return;
        }
        for (ConstantItem constantItem : this.group) {
            constantItem.preProcess(list);
            if (constantItem.isAppGroup()) {
                this.constants.addAll(constantItem.getAllConstants());
                continue;
            }
            this.constants.add(constantItem);
        }
        for (ConstantItem constantItem : this.exceptGroup) {
            constantItem.preProcess(list);
            if (constantItem.isAppGroup()) {
                this.constants.removeAll(constantItem.getAllConstants());
                continue;
            }
            this.constants.remove(constantItem);
        }
        this.preProcessed = true;
    }

    public String toString() {
        String string = this.name + " " + this.group + " " + this.exceptGroup;
        return string;
    }
}

