/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.db;

import commvault.tools.db.ClassType;
import commvault.tools.db.FieldData;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ResultBuilder {
    private final String name;
    private final String packageName;
    private final String dbPackage;
    private final String className;
    private final ClassType type;
    private final Vector<FieldData> fields = new Vector();

    public ResultBuilder(String string, String string2, ClassType classType, String string3) throws Exception {
        this.packageName = string2;
        this.dbPackage = string3;
        this.type = classType;
        this.name = string.toLowerCase().startsWith("dbo.") ? string.substring(4) : string;
        this.className = string + "_t";
    }

    public void addField(FieldData fieldData) {
        this.fields.add(fieldData);
    }

    protected String getPackagePath() {
        return this.convertPackageToPath(this.packageName);
    }

    protected String convertPackageToPath(String string) {
        return StringUtils.replace((String)string, (String)".", (String)"/") + "/";
    }

    public String getType() {
        switch (this.type) {
            case PROC: {
                return "CTEDBStorageType.CTEDB_PROCEDURE";
            }
            case TABLE: {
                return "CTEDBStorageType.CTEDB_TABLE";
            }
            case VIEW: {
                return "CTEDBStorageType.CTEDB_VIEW";
            }
        }
        return "null";
    }

    public void writeClass(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package ").append(this.packageName).append(";\n\n");
        if (!this.packageName.equals(this.dbPackage)) {
            stringBuffer.append("import ").append(this.dbPackage).append(".*;\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("public class ").append(this.className).append(" extends CTEDBStorage {");
        stringBuffer.append("\n\n");
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldData fieldData = this.fields.get(i);
            stringBuffer.append("    ");
            stringBuffer.append("public ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append(" ");
            stringBuffer.append(fieldData.getName());
            stringBuffer.append(" = new ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append("(");
            stringBuffer.append("\"").append(fieldData.getName()).append("\"").append(", ");
            stringBuffer.append(i + 1).append(", ");
            stringBuffer.append(fieldData.isPrimaryKey().toString()).append(", ");
            stringBuffer.append(fieldData.isIdentitiy().toString());
            stringBuffer.append(");");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("    ").append("public ").append(this.className).append("() {").append("\n");
        stringBuffer.append("        ").append("super();").append("\n");
        stringBuffer.append("        ").append("this.initialize();").append("\n");
        stringBuffer.append("    ").append("}");
        stringBuffer.append("\n\n");
        stringBuffer.append("    ").append("protected void initialize() {\n");
        stringBuffer.append("        ").append("this.getColumnStorage().clear();\n");
        for (FieldData fieldData : this.fields) {
            stringBuffer.append("        ").append("this.getColumnStorage().add(").append(fieldData.getName()).append(");\n");
        }
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public String getName() {\n");
        stringBuffer.append("        ").append("return ").append("\"").append(this.name).append("\"").append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public CTEDBStorageType getType() {\n");
        stringBuffer.append("        ").append("return ").append(this.getType()).append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("}");
        this.writeFile(stringBuffer.toString(), string);
    }

    private void writeFile(String string, String string2) throws Exception {
        String string3 = string2 + this.getPackagePath();
        File file = new File(string3);
        file.mkdirs();
        String string4 = string3 + this.className + ".java";
        System.out.println("writing file " + string4);
        FileWriter fileWriter = new FileWriter(string3 + this.className + ".java");
        fileWriter.write(string);
        fileWriter.close();
    }
}

