/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.string;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.string.RemoveType;
import org.apache.commons.lang.StringUtils;

public class RemoveActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RemoveActivity.class);
    @Input(documentation="the string to modify")
    public String text;
    @Input(documentation="the characters to remove")
    public String remove;
    @Input(documentation="the location of where to remove the characters", defaultValue="ANY")
    public RemoveType location;
    @Input(documentation="ignore case", defaultValue="true")
    public Boolean ignoreCase;
    @Output(documentation="the resulting string")
    public String result;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.ignoreCase == null) {
            this.ignoreCase = true;
        }
        if (this.location == null) {
            this.location = RemoveType.ANY;
        }
        if (this.ignoreCase.booleanValue()) {
            switch (this.location) {
                case ANY: {
                    this.result = StringUtils.remove((String)this.text, (String)this.remove);
                    break;
                }
                case START: {
                    this.result = StringUtils.removeStartIgnoreCase((String)this.text, (String)this.remove);
                    break;
                }
                case END: {
                    this.result = StringUtils.removeEndIgnoreCase((String)this.text, (String)this.remove);
                }
            }
        } else {
            switch (this.location) {
                case ANY: {
                    this.result = StringUtils.remove((String)this.text, (String)this.remove);
                    break;
                }
                case START: {
                    this.result = StringUtils.removeStart((String)this.text, (String)this.remove);
                    break;
                }
                case END: {
                    this.result = StringUtils.removeEnd((String)this.text, (String)this.remove);
                }
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

