/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import commvault.cte.workflow.supplemental.net.FTPGetActivity;
import commvault.cte.workflow.supplemental.net.TransferType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.net.tftp.TFTPClient;

public class TFTPActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FTPGetActivity.class);
    @Input
    public String hostName;
    @Input
    public String localFile;
    @Input
    public String remoteFile;
    @Input(defaultValue="SEND")
    public TransferType transferType;
    @Input(defaultValue="false")
    public Boolean binaryTransfer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        TFTPClient tFTPClient = new TFTPClient();
        int n = this.binaryTransfer == null || this.binaryTransfer == false ? 0 : 1;
        tFTPClient.setDefaultTimeout(60000);
        try {
            tFTPClient.open();
        }
        catch (SocketException socketException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "could not open local UDP socket", (Throwable)socketException);
            activityContext.setFailureReason(socketException.getMessage());
            return AttemptStatus.FAILED;
        }
        if (this.transferType == TransferType.RECIEVE) {
            FileOutputStream fileOutputStream = null;
            File file = new File(this.localFile);
            if (file.exists()) {
                logger.error(Long.valueOf(activityContext.getJobId()), "local file [" + file.getAbsolutePath() + "] already exists");
                activityContext.setFailureReason("local file [%s] already exists", new Object[]{file.getAbsolutePath()});
                return AttemptStatus.FAILED;
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                tFTPClient.close();
                logger.error(Long.valueOf(activityContext.getJobId()), "could not open local file [" + file.getAbsolutePath() + "] for writing", (Throwable)iOException);
                activityContext.setFailureReason(iOException.getMessage());
                return AttemptStatus.FAILED;
            }
            try {
                tFTPClient.receiveFile(this.remoteFile, n, (OutputStream)fileOutputStream, this.hostName);
            }
            catch (UnknownHostException unknownHostException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "could not resolve hostname [" + this.hostName + "]", (Throwable)unknownHostException);
                activityContext.setFailureReason(unknownHostException.getMessage());
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                return attemptStatus;
            }
            catch (IOException iOException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "I/O exception occurred while receiving file [" + this.remoteFile + "]", (Throwable)iOException);
                activityContext.setFailureReason(iOException.getMessage());
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                return attemptStatus;
            }
            finally {
                tFTPClient.close();
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error closing file [" + this.localFile + "]", (Throwable)iOException);
                }
            }
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.localFile);
        }
        catch (IOException iOException) {
            tFTPClient.close();
            logger.error(Long.valueOf(activityContext.getJobId()), "could not open local file for reading [" + this.localFile + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        try {
            tFTPClient.sendFile(this.remoteFile, n, (InputStream)fileInputStream, this.hostName);
        }
        catch (UnknownHostException unknownHostException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "could not resolve hostname [" + this.hostName + "]", (Throwable)unknownHostException);
            activityContext.setFailureReason(unknownHostException.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        catch (IOException iOException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "I/O exception occurred while sending file [" + this.localFile + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            tFTPClient.close();
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error closing file [" + this.localFile + "]", (Throwable)iOException);
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

