/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.InputStream;
import workflow.types.EncryptedString;

public class SSHExecActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SSHExecActivity.class);
    @Input
    public String hostName;
    @Input(defaultValue="22")
    public Integer port;
    @Input
    public String userName;
    @Input
    public EncryptedString password;
    @Input
    public String command;
    @Output(documentation="the return code recieved from completion of the command")
    public int errorCode;
    @Output(documentation="the output from the command or error message if it failed")
    public String commandOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Session session;
        if (this.port == null) {
            this.port = 22;
        }
        JSch jSch = new JSch();
        try {
            session = jSch.getSession(this.userName, this.hostName, this.port.intValue());
        }
        catch (JSchException jSchException) {
            this.errorCode = -1;
            this.commandOutput = jSchException.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to get jsch session for host [" + this.hostName + "], port [" + this.port + "]", (Throwable)jSchException);
            activityContext.setFailureReason(jSchException.getMessage());
            return AttemptStatus.FAILED;
        }
        session.setPassword(this.password.getPlainText());
        session.setConfig("StrictHostKeyChecking", "no");
        try {
            session.connect();
        }
        catch (JSchException jSchException) {
            this.errorCode = -1;
            this.commandOutput = jSchException.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to authenticate to remote SSH host with username [" + this.userName + "]", (Throwable)jSchException);
            activityContext.setFailureReason(jSchException.getMessage());
            return AttemptStatus.FAILED;
        }
        Channel channel = null;
        try {
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(this.command);
            channel.setInputStream(null);
            InputStream inputStream = channel.getInputStream();
            channel.connect();
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                    stringBuffer.append(new String(byArray, 0, n));
                    continue;
                }
                if (channel.isClosed()) break;
                Thread.sleep(1000L);
            }
            this.errorCode = channel.getExitStatus();
            logger.info(Long.valueOf(activityContext.getJobId()), "execution of command [%s] on host [%s] completed with errorCode [%s], output [%s]", new Object[]{this.command, this.hostName, this.errorCode, stringBuffer.toString()});
            this.commandOutput = this.errorCode == 0 ? stringBuffer.toString() : WorkflowUtils.readStream((InputStream)((ChannelExec)channel).getErrStream());
        }
        catch (Exception exception) {
            this.errorCode = -1;
            this.commandOutput = exception.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute command via ssh", (Throwable)exception);
            activityContext.setFailureReason(exception.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            session.disconnect();
        }
        return AttemptStatus.SUCCESS;
    }
}

