/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HTTPGetActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(HTTPGetActivity.class);
    @Input
    public String url;
    @Output
    public Integer statusCode;
    @Output
    public String statusText;
    @Output
    public String output;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        HttpGet httpGet = new HttpGet(this.url);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.useSystemProperties();
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity != null) {
                this.output = IOUtils.toString((InputStream)new BOMInputStream(httpEntity.getContent()), (String)"UTF-8");
            }
            this.statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
            this.statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to read response from url [" + this.url + "]", (Throwable)exception);
            activityContext.setFailureReason(exception.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (closeableHttpResponse != null) {
                try {
                    closeableHttpResponse.close();
                }
                catch (IOException iOException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to close http response object", (Throwable)iOException);
                }
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

