/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.net.FTPConnection;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;

public class FTPUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FTPUtil.class);

    public static FTPClient createClient(FTPConnection fTPConnection) {
        return new FTPClient();
    }

    public static void initClient(FTPClient fTPClient, FTPConnection fTPConnection, long l) throws EvFailureException {
        try {
            if (fTPConnection.port > 0) {
                fTPClient.connect(fTPConnection.server, fTPConnection.port);
            } else {
                fTPClient.connect(fTPConnection.server);
            }
            logger.details(Long.valueOf(l), "Connected to ftp server [%s]", new Object[]{fTPConnection.server});
            int n = fTPClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                fTPClient.disconnect();
                logger.error(Long.valueOf(l), "ftp server [" + fTPConnection.server + "] refused connection: [" + n + "]");
                throw new EvFailureException(new EvMessageContainer("ftp server [%s] refused connection", new Object[]{fTPConnection.server}));
            }
        }
        catch (IOException iOException) {
            if (fTPClient.isConnected()) {
                try {
                    fTPClient.disconnect();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            logger.error(Long.valueOf(l), "failed to connect to ftp server [" + fTPConnection.server + "]", (Throwable)iOException);
            throw new EvFailureException(new EvMessageContainer("failed to connect to ftp server [%s]", new Object[]{fTPConnection.server}));
        }
        try {
            if (!fTPClient.login(fTPConnection.userName, fTPConnection.password.getPlainText())) {
                logger.error(Long.valueOf(l), "failed to login into ftp server [" + fTPConnection.server + "] with username [" + fTPConnection.userName + "]");
                throw new EvFailureException(new EvMessageContainer("failed to login into ftp server [%s] with username [%s]", new Object[]{fTPConnection.server, fTPConnection.userName}));
            }
        }
        catch (IOException iOException) {
            logger.error(Long.valueOf(l), "failed to login into ftp server [" + fTPConnection.server + "] with username [" + fTPConnection.userName + "]", (Throwable)iOException);
            throw new EvFailureException(new EvMessageContainer(iOException.getMessage()));
        }
    }

    public static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal = 0L;

            public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
                this.bytesTransferred(copyStreamEvent.getTotalBytesTransferred(), copyStreamEvent.getBytesTransferred(), copyStreamEvent.getStreamSize());
            }

            public void bytesTransferred(long l, int n, long l2) {
                long l3 = l / 1000000L;
                for (long i = this.megsTotal; i < l3; ++i) {
                }
                this.megsTotal = l3;
            }
        };
    }
}

