/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.net.FTPConnection;
import commvault.cte.workflow.supplemental.net.FTPUtil;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.net.ftp.FTPClient;

public class FTPRemoteCopyActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FTPRemoteCopyActivity.class);
    @Input
    public FTPConnection srcConnection;
    @Input
    public String srcFile;
    @Input
    public FTPConnection destConnection;
    @Input
    public String destFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        FTPClient fTPClient;
        FTPClient fTPClient2;
        block35: {
            if (this.srcConnection == null) {
                logger.error(Long.valueOf(activityContext.getJobId()), "invalid source connection specified");
                activityContext.setFailureReason("invalid source connection specified");
                return AttemptStatus.FAILED;
            }
            if (this.destConnection == null) {
                logger.error(Long.valueOf(activityContext.getJobId()), "invalid destination connection specified");
                activityContext.setFailureReason("invalid destination connection specified");
                return AttemptStatus.FAILED;
            }
            fTPClient2 = FTPUtil.createClient(this.srcConnection);
            fTPClient = FTPUtil.createClient(this.destConnection);
            try {
                FTPUtil.initClient(fTPClient2, this.srcConnection, activityContext.getJobId());
                FTPUtil.initClient(fTPClient, this.destConnection, activityContext.getJobId());
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                if (fTPClient2.isConnected()) {
                    try {
                        fTPClient2.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!fTPClient.isConnected()) return attemptStatus;
                try {
                    fTPClient.disconnect();
                    return attemptStatus;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return attemptStatus;
            }
            fTPClient.enterRemotePassiveMode();
            fTPClient2.enterRemoteActiveMode(InetAddress.getByName(fTPClient.getPassiveHost()), fTPClient.getPassivePort());
            if (fTPClient2.remoteRetrieve(this.srcFile) && fTPClient.remoteStoreUnique(this.destFile)) {
                fTPClient2.completePendingCommand();
                fTPClient.completePendingCommand();
                break block35;
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to initiate transfer");
            activityContext.setFailureReason("failed to initiate transfer");
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            if (fTPClient2.isConnected()) {
                try {
                    fTPClient2.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!fTPClient.isConnected()) return attemptStatus;
            try {
                fTPClient.disconnect();
                return attemptStatus;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return attemptStatus;
        }
        try {
            return AttemptStatus.SUCCESS;
        }
        finally {
            if (fTPClient2.isConnected()) {
                try {
                    fTPClient2.disconnect();
                }
                catch (IOException iOException) {}
            }
            if (fTPClient.isConnected()) {
                try {
                    fTPClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

