/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.job;

import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class JobUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JobUtil.class);

    public static List<Long> getRunningInstances(ActivityContext activityContext) throws EvFailureException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("Select a.jobId From JMAdminJobInfoTable a INNER JOIN JMJobInfo j ON a.jobId = j.jobId INNER JOIN JMJobStats s ON a.jobId = s.jobId Where s.status = 1 AND a.workFlowId = ? AND a.jobId <> ? AND Cast(j.currentPhaseName as nvarchar(255)) <> ?");
            preparedStatement.setInt(1, activityContext.getWorkflowId());
            preparedStatement.setLong(2, activityContext.getJobId());
            preparedStatement.setString(3, activityContext.getStepName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(1));
            }
        }
        return arrayList;
    }
}

