/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class WriteTextActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WriteTextActivity.class);
    @Input
    public String file;
    @Input
    public String contents;
    @Input(defaultValue="true")
    public Boolean append;
    @Output
    public String filePath;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        if (this.append == null) {
            this.append = true;
        }
        File file = new File(this.file);
        try {
            FileUtils.writeStringToFile((File)file, (String)this.contents, (String)"UTF-8", (boolean)this.append);
        }
        catch (IOException iOException) {
            logger.error("error writing to file [" + this.file + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        this.filePath = file.getAbsolutePath();
        return AttemptStatus.SUCCESS;
    }
}

