/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import commvault.cte.workflow.supplemental.io.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;

public class ReadTextActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ReadTextActivity.class);
    @Input
    public String file;
    @Output
    public String contents;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        try {
            File file = new File(this.file);
            String string = TextUtil.detectEncoding(file);
            BOMInputStream bOMInputStream = new BOMInputStream((InputStream)new FileInputStream(file));
            this.contents = string != null && string.length() > 0 ? IOUtils.toString((InputStream)bOMInputStream, (String)string) : IOUtils.toString((InputStream)bOMInputStream, (String)"UTF-8");
        }
        catch (Exception exception) {
            logger.error("error reading file [" + this.file + "]", (Throwable)exception);
            activityContext.setFailureReason(exception.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

