/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.IOException;
import org.apache.commons.io.FileSystemUtils;

public class FreeSpaceActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FreeSpaceActivity.class);
    @Input(documentation="the volume to get the free space on, i.e. C:", defaultValue="C:")
    public String volume;
    @Output(documentation="returns the free space in KB")
    public Long freeSpaceKb;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        try {
            this.freeSpaceKb = FileSystemUtils.freeSpaceKb((String)this.volume);
        }
        catch (IOException iOException) {
            logger.error("error retrieving free space on volume [" + this.volume + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

