/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class DirectoryContainsActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DirectoryContainsActivity.class);
    @Input
    public String directory;
    @Input
    public String file;
    @Output
    public Boolean exists;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        try {
            this.exists = FilenameUtils.directoryContains((String)this.directory, (String)this.file);
        }
        catch (IOException iOException) {
            logger.error("error checking if file [" + this.file + "] exists in directory [" + this.directory + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

