/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.db;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.CommCellEntity;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workflow.types.EncryptedString;
import workflow.types.data.DataSet;

public class SQLQueryActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SQLQueryActivity.class);
    @Input(documentation="the server and instance with database on it")
    public String server;
    @Input(documentation="the name of the database to execute the query on")
    public String databaseName;
    @Input(documentation="the username to connect to the database")
    public String userName;
    @Input(documentation="the password to connect to the database")
    public EncryptedString password;
    @Input(documentation="the sql query to execute on the database")
    public String query;
    @Output
    public List<DataSet> resultSets;
    @Output
    public int errorCode;
    @Output
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.errorCode = 0;
        this.errorMessage = "";
        if (this.query == null || this.query.length() == 0) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "no query to execute in activity [%s]", new Object[]{activityContext.getFriendlyName()});
            return AttemptStatus.SUCCESS;
        }
        String string = String.format("jdbc:sqlserver://%s;databaseName=%s;", this.server, this.databaseName);
        try {
            this.resultSets = this.executeBatch(string, this.userName, this.password.getPlainText(), this.query);
        }
        catch (CTEDBException cTEDBException) {
            this.errorCode = cTEDBException.getErrorCode();
            this.errorMessage = cTEDBException.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute database query [" + this.query + "]", (Throwable)cTEDBException);
            activityContext.setFailureReason(cTEDBException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    public List<DataSet> executeBatch(String string, String string2, String string3, String string4) throws CTEDBException {
        ArrayList<DataSet> arrayList;
        Connection connection;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            if (!statement.execute(string4)) {
                List<DataSet> list = null;
                return list;
            }
            ArrayList<DataSet> arrayList2 = new ArrayList<DataSet>();
            arrayList2.add(new DataSet(statement.getResultSet(), (CommCellEntity)null));
            while (statement.getMoreResults()) {
                arrayList2.add(new DataSet(statement.getResultSet(), (CommCellEntity)null));
            }
            arrayList = arrayList2;
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }
}

