/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.date;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

public class ParseDateActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ParseDateActivity.class);
    @Input(documentation="the date to format")
    public String date;
    @Input
    public List<String> patterns;
    @Output(documentation="the resulting date")
    public Date result;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            this.result = DateUtils.parseDate((String)this.date, (String[])this.patterns.toArray(new String[0]));
        }
        catch (ParseException parseException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse date [" + this.date + "] using patterns " + this.patterns, (Throwable)parseException);
            activityContext.setFailureReason(parseException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

