/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.AssertUtils;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropAccessNodeFactory;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;

abstract class InteropAccessNode
extends Node {
    static final int ARG0_RECEIVER = 0;
    protected static final int CACHE_SIZE = 8;
    protected final Message message;

    protected InteropAccessNode(Message message) {
        this.message = message;
    }

    public final Object execute(TruffleObject receiver) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver}));
    }

    public final Object executeOrFalse(TruffleObject receiver) throws InteropException {
        try {
            return InteropAccessNode.checkInteropType(this.executeImplInterop(receiver, new Object[]{receiver}));
        }
        catch (UnsupportedMessageException ex) {
            this.enterDefaultUnsupported();
            return false;
        }
    }

    protected void enterDefaultUnsupported() {
    }

    public final Object execute(TruffleObject receiver, Object[] arguments) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg1(arguments, receiver)));
    }

    public final Object execute(TruffleObject receiver, Object arg0) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver, InteropAccessNode.checkInteropType(arg0)}));
    }

    public final Object execute(TruffleObject receiver, Object arg0, Object arg1) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, new Object[]{receiver, InteropAccessNode.checkInteropType(arg0), InteropAccessNode.checkInteropType(arg1)}));
    }

    public final Object execute(TruffleObject receiver, Object arg0, Object[] arguments) throws InteropException {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg2(arguments, receiver, arg0)));
    }

    @Deprecated
    public final Object executeOld(TruffleObject receiver, Object[] arguments) {
        return InteropAccessNode.checkInteropType(this.executeImpl(receiver, this.insertArg1(arguments, receiver)));
    }

    private Object[] insertArg1(Object[] arguments, Object arg0) {
        int length = this.profileLength(arguments.length);
        Object[] newArguments = new Object[length + 1];
        newArguments[0] = InteropAccessNode.checkInteropType(arg0);
        InteropAccessNode.arraycopy(arguments, 0, newArguments, 1, length);
        return newArguments;
    }

    private Object[] insertArg2(Object[] arguments, Object arg0, Object arg1) {
        int length = this.profileLength(arguments.length);
        Object[] newArguments = new Object[length + 2];
        newArguments[0] = InteropAccessNode.checkInteropType(arg0);
        newArguments[1] = InteropAccessNode.checkInteropType(arg1);
        InteropAccessNode.arraycopy(arguments, 0, newArguments, 2, length);
        return newArguments;
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = InteropAccessNode.checkInteropType(src[srcPos + i]);
        }
    }

    static Object checkInteropType(Object obj) {
        assert (InteropAccessNode.checkInteropTypeImpl(obj));
        return obj;
    }

    private static boolean checkInteropTypeImpl(Object obj) {
        if (AssertUtils.isInteropValue(obj)) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        Class<?> clazz = obj != null ? obj.getClass() : null;
        return InteropAccessNode.yieldAnError(clazz);
    }

    private static boolean yieldAnError(Class<?> clazz) {
        CompilerDirectives.transferToInterpreter();
        StringBuilder sb = new StringBuilder();
        sb.append(clazz == null ? "null" : clazz.getName());
        sb.append(" isn't allowed Truffle interop type!\n");
        if (clazz == null) {
            throw new NullPointerException(sb.toString());
        }
        throw new ClassCastException(sb.toString());
    }

    @CompilerDirectives.TruffleBoundary
    protected CallTarget createGenericMessageTarget(TruffleObject receiver) {
        assert (InteropAccessNode.assertHandlesItself(receiver));
        return this.createMessageTarget(receiver.getForeignAccess());
    }

    private static boolean assertHandlesItself(TruffleObject receiver) {
        if (receiver.getForeignAccess() != null) {
            InteropAccessNode.createCanHandleInlinedCallNode(receiver.getForeignAccess(), receiver);
        }
        return true;
    }

    protected final CallTarget createMessageTarget(ForeignAccess fa) {
        CallTarget ct = null;
        if (fa != null) {
            ct = fa.access(this.message);
        }
        if (ct == null) {
            return Truffle.getRuntime().createCallTarget(new RootNode(null){

                @Override
                public Object execute(VirtualFrame frame) {
                    throw UnsupportedMessageException.raise(InteropAccessNode.this.message);
                }
            });
        }
        return ct;
    }

    protected static boolean acceptCached(TruffleObject receiver, ForeignAccess foreignAccess, DirectCallNode canHandleCall) {
        if (canHandleCall != null) {
            return (Boolean)canHandleCall.call(receiver);
        }
        if (foreignAccess != null) {
            return foreignAccess.canHandle(receiver);
        }
        return false;
    }

    protected static DirectCallNode createInlinedCallNode(CallTarget target) {
        if (target == null) {
            return null;
        }
        DirectCallNode callNode = DirectCallNode.create(target);
        callNode.forceInlining();
        return callNode;
    }

    @CompilerDirectives.TruffleBoundary
    protected static DirectCallNode createCanHandleInlinedCallNode(ForeignAccess access, TruffleObject receiver) {
        if (access != null) {
            DirectCallNode callNode = InteropAccessNode.createInlinedCallNode(access.checkLanguage());
            assert (InteropAccessNode.acceptCached(receiver, access, callNode)) : "foreign access for " + receiver.getClass() + " (" + access + ") does not handle its own objects";
            return callNode;
        }
        return null;
    }

    protected abstract int profileLength(int var1);

    private Object executeImplInterop(TruffleObject receiver, Object[] arguments) throws InteropException {
        return this.executeImpl(receiver, arguments);
    }

    protected abstract Object executeImpl(TruffleObject var1, Object[] var2);

    public static InteropAccessNode create(Message message) {
        return InteropAccessNodeFactory.CachedNodeGen.create(message);
    }

    public static InteropAccessNode getUncached(Message message) {
        InteropAccessNode node = message.uncached;
        if (node == null) {
            message.uncached = node = new Uncached(message);
        }
        return node;
    }

    static abstract class CachedNode
    extends InteropAccessNode {
        static final int ARG0_RECEIVER = 0;
        protected static final int CACHE_SIZE = 8;
        @CompilerDirectives.CompilationFinal
        private int previousLength = -2;
        private final BranchProfile profileDefaultUnsupported = BranchProfile.create();

        protected CachedNode(Message message) {
            super(message);
        }

        @Override
        protected void enterDefaultUnsupported() {
            this.profileDefaultUnsupported.enter();
        }

        @Override
        protected int profileLength(int length) {
            int returnLength = length;
            if (this.previousLength != -1) {
                if (this.previousLength == length) {
                    returnLength = this.previousLength;
                } else {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.previousLength = this.previousLength == -2 ? length : -1;
                }
            }
            return returnLength;
        }

        @Specialization(guards={"acceptCached(receiver, foreignAccess, canHandleCall)"}, limit="CACHE_SIZE")
        protected static Object doCached(TruffleObject receiver, Object[] arguments, @Cached(value="receiver.getForeignAccess()") ForeignAccess foreignAccess, @Cached(value="createInlinedCallNode(createMessageTarget(foreignAccess))") DirectCallNode sendMessageCall, @Cached(value="createCanHandleInlinedCallNode(foreignAccess, receiver)") DirectCallNode canHandleCall) {
            return sendMessageCall.call(arguments);
        }

        @Specialization
        protected Object doGeneric(TruffleObject receiver, Object[] arguments, @Cached(value="create()") IndirectCallNode indirectCall) {
            return indirectCall.call(this.createGenericMessageTarget(receiver), arguments);
        }
    }

    static final class Uncached
    extends InteropAccessNode {
        Uncached(Message message) {
            super(message);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected int profileLength(int length) {
            return length;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(TruffleObject receiver, Object[] arguments) {
            return this.createGenericMessageTarget(receiver).call(arguments);
        }
    }
}

