/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.RelocatableUtils;

public class RelocatableVector {
    int vecsize;
    private int startElementIndex;
    private int sizeOfElement;

    RelocatableVector(int n, int n2) {
        this.sizeOfElement = n2;
        this.vecsize = RelocatableUtils.getInstance().getIntAtLoc(n);
        this.startElementIndex = RelocatableUtils.getInstance().getRelocatablePointer(n + 4);
    }

    public int getAtIndex(int n) {
        if (n >= 0 && n < this.vecsize) {
            return this.startElementIndex + n * this.sizeOfElement;
        }
        return -1;
    }

    public int runBinarySearchForInt(int n) {
        int n2 = 0;
        int n3 = this.vecsize - 1;
        int n4 = -1;
        while (n2 <= n3) {
            int n5 = (n2 + n3) / 2;
            int n6 = RelocatableUtils.getInstance().getIntAtLoc(this.getAtIndex(n5));
            if (n6 < n) {
                n2 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 != n) continue;
            n4 = n5;
            break;
        }
        return n4;
    }

    public int runCaseSensitiveBinarySearchForString(String string) {
        int n = 0;
        int n2 = this.vecsize - 1;
        int n3 = -1;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            String string2 = RelocatableUtils.getInstance().getRelocatableString(this.getAtIndex(n4));
            int n5 = string2.compareTo(string);
            if (n5 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n5 != 0) continue;
            n3 = n4;
            break;
        }
        return n3;
    }

    public int runCaseInsensitiveBinarySearchForString(String string) {
        int n = 0;
        int n2 = this.vecsize - 1;
        int n3 = -1;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            String string2 = RelocatableUtils.getInstance().getRelocatableString(this.getAtIndex(n4));
            int n5 = string2.compareToIgnoreCase(string);
            if (n5 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n5 != 0) continue;
            n3 = n4;
            break;
        }
        return n3;
    }

    public int runBinarySearchForShort(int n) {
        int n2 = 0;
        int n3 = this.vecsize - 1;
        int n4 = -1;
        while (n2 <= n3) {
            int n5 = (n2 + n3) / 2;
            short s = RelocatableUtils.getInstance().getShortAtLoc(this.getAtIndex(n5));
            if (s < n) {
                n2 = n5 + 1;
                continue;
            }
            if (s > n) {
                n3 = n5 - 1;
                continue;
            }
            if (s != n) continue;
            n4 = n5;
            break;
        }
        return n4;
    }
}

