/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.CachedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class ObjectCache {
    private static final long CLEANUP_INTERVAL_IN_MILLIS = 60000L;
    private static final long INITIAL_DELAY_IN_MILLIS = 300000L;
    private static final long MAX_LIFE_FOR_CACHED_OBJECT_IN_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static Map<String, CachedObject> cache = Collections.synchronizedMap(new HashMap());

    private ObjectCache() {
    }

    private static void initCleanupThread() {
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = cache;
                synchronized (map) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : cache.keySet()) {
                        CachedObject cachedObject = (CachedObject)cache.get(string);
                        if (!ObjectCache.isExpired(cachedObject)) continue;
                        arrayList.add(string);
                    }
                    for (String string : arrayList) {
                        cache.remove(string);
                    }
                }
            }
        };
        new Timer(true).schedule(timerTask, 300000L, 60000L);
    }

    private static boolean isExpired(CachedObject cachedObject) {
        if (cachedObject.isAlwaysAlive()) {
            return false;
        }
        long l = cachedObject.getLife() == 0L ? MAX_LIFE_FOR_CACHED_OBJECT_IN_NANOS : cachedObject.getLife();
        return System.nanoTime() - cachedObject.getLastAccessTime() > l;
    }

    public static Object get(String string) {
        return cache.containsKey(string) ? cache.get(string).getData(true) : null;
    }

    public static void put(String string, Object object) {
        cache.put(string, new CachedObject(object));
    }

    public static void put(String string, Object object, long l) {
        cache.put(string, new CachedObject(object, l));
    }

    public static void remove(String string) {
        cache.remove(string);
    }

    public static void clear() {
        cache.clear();
    }

    public static Set<String> getAllKeys() {
        return cache.keySet();
    }

    static {
        ObjectCache.initCleanupThread();
    }
}

