/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.CteStringBank;
import commvault.cte.component.calender.TimeZonePanel;
import commvault.cte.component.dock.IContext;
import commvault.cte.net.IdIdNameItem;
import commvault.cte.util.Application;
import commvault.cte.util.CVTimezone;
import commvault.cte.util.CurrentUserKeyReader;
import commvault.cte.util.Logger;
import commvault.cte.util.RuntimeContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateUtilities {
    public static final String FORMAT_EEE_MMddyyyy = "EEE MM/dd/yyyy";
    public static final String FORMAT_MMMyyyy = "MMM yyyy";
    public static final String FORMAT_MMddyyyy = "MM/dd/yyyy";
    public static final String FORMAT_MMddyyyyHHmmss = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT_MMddyyyyHHmm = "MM/dd/yyyy HH:mm";
    public static final String FORMAT_MMddyyyyhhmmaa = "MM/dd/yyyy hh:mm aa";
    public static final String FORMAT_yyyyMMdd = "yyyy/MM/dd";
    public static String systemLongDateFormat;
    public static String systemShortDateFormat;
    public static String systemTimeFormat;
    public static String systemLongTimeFormat;
    public static boolean useUserDateFormat;
    private boolean useUserdefinedDateTimeFormat = false;
    private String userdefinedLongDateFormat;
    private String userdefinedShortDateFormat;
    private String userdefinedTimeFormat;
    private String userdefinedLongTimeFormat;
    private int userdefinedTimeZone;
    private static TimeZone currentSystemTimeZone;
    private UserTimeZone userTimeZone = UserTimeZone.Sys_TimeZone;
    private static DateUtilities instance;

    private static boolean isValidFormat(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, DateUtilities.getUserLocal());
        }
        catch (Exception exception) {
            String string2 = "Invalid foramt : " + string + " error message " + exception.getMessage();
            System.out.println(string2);
            Logger.instance().println(Logger.ERROR, string2);
            return false;
        }
        return true;
    }

    private static String getDateFormat(int n, Locale locale) {
        return ((SimpleDateFormat)SimpleDateFormat.getDateInstance(n, locale)).toPattern();
    }

    private static String getTimeFormat(int n, Locale locale) {
        return ((SimpleDateFormat)SimpleDateFormat.getTimeInstance(n, locale)).toPattern();
    }

    public static DateUtilities instance(IContext iContext) {
        if (instance == null) {
            instance = new DateUtilities();
        }
        return instance;
    }

    public static DateUtilities instance() {
        if (instance == null) {
            instance = new DateUtilities();
        }
        return instance;
    }

    private DateUtilities() {
    }

    public boolean isUseUserdefinedDateTimeFormat() {
        return this.useUserdefinedDateTimeFormat;
    }

    public void setUseUserdefinedDateTimeFormat(boolean bl) {
        this.useUserdefinedDateTimeFormat = bl;
    }

    public String getUserdefinedShortDateFormat() {
        return this.userdefinedShortDateFormat;
    }

    public void setUserdefinedShortDateFormat(String string) {
        this.userdefinedShortDateFormat = string;
    }

    public String getUserdefinedLongDateFormat() {
        return this.userdefinedLongDateFormat;
    }

    public void setUserdefinedLongDateFormat(String string) {
        this.userdefinedLongDateFormat = string;
    }

    public String getUserdefinedTimeFormat() {
        return this.userdefinedTimeFormat;
    }

    public void setUserdefinedTimeFormat(String string) {
        this.userdefinedTimeFormat = string;
    }

    public String getUserdefinedLongTimeFormat() {
        return this.userdefinedLongTimeFormat;
    }

    public void setUserdefinedLongTimeFormat(String string) {
        this.userdefinedLongTimeFormat = string;
    }

    public int getUserdefinedTimeZone() {
        return this.userdefinedTimeZone;
    }

    public void setUserdefinedTimeZone(int n) {
        this.userdefinedTimeZone = n;
    }

    public UserTimeZone getUserTimeZone() {
        return this.userTimeZone;
    }

    public void setUserTimeZone(UserTimeZone userTimeZone) {
        this.userTimeZone = userTimeZone;
        if (UserTimeZone.Sys_TimeZone == userTimeZone) {
            currentSystemTimeZone = DateUtilities.getCurrentSystemTimeZone();
        }
    }

    public void updateCurrentSystemTimeZone() {
        currentSystemTimeZone = DateUtilities.getCurrentSystemTimeZone();
    }

    private static TimeZone getCurrentSystemTimeZone() {
        if (Application.instance().getTimezones().size() > 0 && System.getProperty("os.name").indexOf("Windows") > -1) {
            String string = "SYSTEM\\CurrentControlSet\\Control\\TimeZoneInformation";
            String string2 = CurrentUserKeyReader.getLocalMachineKeyValue(string, "TimeZoneKeyName");
            String string3 = new String(new byte[]{0});
            string2 = string2.split(string3)[0];
            for (TimeZone timeZone : Application.instance().getTimezones().values()) {
                String string4;
                if (!(timeZone instanceof CVTimezone) || !string2.equals(string4 = ((CVTimezone)timeZone).getTimeZoneStdName())) continue;
                return timeZone;
            }
        }
        return DateUtilities.getCommserveTimezone();
    }

    public static TimeZone getTimeZone() {
        TimeZone timeZone;
        DateUtilities dateUtilities = DateUtilities.instance();
        if (dateUtilities.getUserTimeZone() == UserTimeZone.User_TimeZone) {
            timeZone = Application.instance().getTimzone(dateUtilities.getUserdefinedTimeZone());
        } else if (dateUtilities.getUserTimeZone() == UserTimeZone.Sys_TimeZone) {
            if (currentSystemTimeZone == null) {
                currentSystemTimeZone = DateUtilities.getCurrentSystemTimeZone();
            }
            timeZone = currentSystemTimeZone;
        } else {
            timeZone = DateUtilities.getCommserveTimezone();
        }
        return timeZone;
    }

    public String getUserShortDateAndLongTimeFormat() {
        String string = "";
        String string2 = "";
        if (this.isUseUserdefinedDateTimeFormat()) {
            string = this.getUserdefinedShortDateFormat();
            string2 = this.getUserdefinedLongTimeFormat();
        } else {
            string = systemShortDateFormat;
            string2 = systemLongTimeFormat;
        }
        return string + " " + DateUtilities.processTimeFormat(string2);
    }

    public String getUserSpecificDateAndTimeFormat() {
        String string = "";
        String string2 = "";
        if (this.isUseUserdefinedDateTimeFormat()) {
            string = this.getUserdefinedShortDateFormat();
            string2 = this.getUserdefinedTimeFormat();
        } else {
            string = systemShortDateFormat;
            string2 = systemTimeFormat;
        }
        return string + " " + DateUtilities.processTimeFormat(string2);
    }

    public String getUserSpecificLongDateAndTimeFormat(int n) {
        return DateUtilities.getFormattedDate(n, this.getUserSpecificLongDateAndTimeFormat(), DateUtilities.getCommserveTimezone());
    }

    public String getUserSpecificLongDateAndTimeFormat() {
        String string = "";
        String string2 = "";
        if (this.isUseUserdefinedDateTimeFormat()) {
            string = this.getUserdefinedLongDateFormat();
            string2 = this.getUserdefinedLongTimeFormat();
        } else {
            string = systemLongDateFormat;
            string2 = systemLongTimeFormat;
        }
        return DateUtilities.processDateFormat(string) + " " + DateUtilities.processTimeFormat(string2);
    }

    public static String processTimeFormat(String string) {
        string = string.replaceAll("t", "a");
        return string;
    }

    public static String processDateFormat(String string) {
        if (string.startsWith("dddd")) {
            string = "EEEE" + string.substring(4);
        }
        return string;
    }

    public String getUserSpecificTimeFormat() {
        String string = "";
        string = this.isUseUserdefinedDateTimeFormat() ? this.getUserdefinedTimeFormat() : systemTimeFormat;
        return DateUtilities.processTimeFormat(string);
    }

    public String getUserSpecificLongTimeFormat() {
        String string = "";
        string = this.isUseUserdefinedDateTimeFormat() ? this.getUserdefinedLongTimeFormat() : systemLongTimeFormat;
        return DateUtilities.processTimeFormat(string);
    }

    public String getUserSpecificLongDateFormat() {
        String string = "";
        string = this.isUseUserdefinedDateTimeFormat() ? this.getUserdefinedLongDateFormat() : systemLongDateFormat;
        return DateUtilities.processDateFormat(string);
    }

    public String getUserSpecificLongDateFormat(long l) {
        return DateUtilities.getFormattedDate(l, this.getUserSpecificLongDateFormat(), DateUtilities.getTimeZone());
    }

    public String getUserSpecificShortDateFormat() {
        String string = "";
        string = this.isUseUserdefinedDateTimeFormat() ? this.getUserdefinedShortDateFormat() : systemShortDateFormat;
        return string;
    }

    public String getUserSpecificShortDateFormat(long l) {
        return DateUtilities.getFormattedDate(l, this.getUserSpecificShortDateFormat(), DateUtilities.getTimeZone());
    }

    public String getUserSpecificDateAndTimeFormat(String string, long l) {
        if (useUserDateFormat && l > 0L) {
            return DateUtilities.getFormattedDate(l, this.getUserSpecificDateAndTimeFormat(), DateUtilities.getTimeZone());
        }
        return string;
    }

    public String getUserShortDateAndLongTimeFormat(String string, long l) {
        if (useUserDateFormat && l > 0L) {
            return DateUtilities.getFormattedDate(l, this.getUserShortDateAndLongTimeFormat(), DateUtilities.getTimeZone());
        }
        return string;
    }

    public String getUserSpecificTimeFormat(long l) {
        return DateUtilities.getFormattedDate(l, this.getUserSpecificTimeFormat(), DateUtilities.getTimeZone());
    }

    public String getUserSpecificTimeFormatInGMT(long l) {
        return DateUtilities.getFormattedDate(l, this.getUserSpecificTimeFormat(), TimeZone.getTimeZone("GMT"));
    }

    public String getUserSpecificDateAndTimeFormat(long l) {
        return DateUtilities.getFormattedDate(l, this.getUserSpecificDateAndTimeFormat(), DateUtilities.getTimeZone());
    }

    public String getUserSpecificDateAndTimeFormatRoundUp(long l) {
        return DateUtilities.getFormattedDateRoundUp(l, this.getUserSpecificDateAndTimeFormat(), DateUtilities.getTimeZone());
    }

    public static String getFormattedDateRoundUp(long l, String string, TimeZone timeZone) {
        if (l < 0L || string == null) {
            return CteStringBank.Not_Applicable.getI18n();
        }
        long l2 = l * 1000L;
        Date date = new Date();
        date.setTime(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, DateUtilities.getUserLocal());
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat.format(DateUtilities.toNearestWholeMinute(date));
    }

    public static Date toNearestWholeMinute(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(13) >= 30) {
            ((Calendar)gregorianCalendar).add(12, 1);
        }
        gregorianCalendar.set(13, 0);
        return gregorianCalendar.getTime();
    }

    public static String getFormattedDate(long l, String string, TimeZone timeZone) {
        if (l < 0L || string == null) {
            return CteStringBank.Not_Applicable.getI18n();
        }
        long l2 = l * 1000L;
        Date date = new Date();
        date.setTime(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, DateUtilities.getUserLocal());
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat.format(date);
    }

    public static Locale getUserLocal() {
        return RuntimeContext.instance().getLoggedInLocale();
    }

    public static String getFormattedDate(long l, String string) {
        return DateUtilities.getFormattedDate(l, string, DateUtilities.getCommserveTimezone());
    }

    public static TimeZone getCommserveTimezone() {
        TimeZone timeZone = Application.commServerTimeZone;
        for (TimeZone timeZone2 : Application.instance().getTimezones().values()) {
            if (!(timeZone2 instanceof CVTimezone) || !timeZone.getID().equals(((CVTimezone)timeZone2).getID())) continue;
            return timeZone2;
        }
        return timeZone;
    }

    public static String getFormattedDate(long l) {
        return DateUtilities.getFormattedDate(l, FORMAT_MMddyyyy, DateUtilities.getCommserveTimezone());
    }

    public String getFormattedDate(long l, int n, TimeZone timeZone) {
        if (l < 0L || n < 0) {
            return CteStringBank.Not_Applicable.getI18n();
        }
        long l2 = l * 1000L;
        Date date = new Date();
        date.setTime(l2);
        DateFormat dateFormat = DateFormat.getDateInstance(n);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public String getFormattedDate(long l, int n) {
        return this.getFormattedDate(l, n, DateUtilities.getCommserveTimezone());
    }

    public String getDateOnlyString(long l) {
        return this.getFormattedDate(l, 3, DateUtilities.getCommserveTimezone());
    }

    public String getDateString(long l, IdIdNameItem idIdNameItem) {
        TimeZone timeZone = DateUtilities.getCommserveTimezone();
        if (timeZone != null) {
            timeZone = TimeZonePanel.getTimeZone(idIdNameItem);
        }
        return DateUtilities.getFormattedDate(l, this.getUserSpecificDateAndTimeFormat(), timeZone);
    }

    public static SimpleTimeZone getTimeZone(IdIdNameItem idIdNameItem) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(TimeZone.getDefault().getRawOffset(), TimeZone.getDefault().getID()){

            @Override
            public String toString() {
                return this.getID();
            }
        };
        simpleTimeZone.setStartRule(0, 0, 0);
        simpleTimeZone.setID(idIdNameItem.toString());
        simpleTimeZone.setRawOffset(-(idIdNameItem.getSecondId() - 86400) * 1000);
        return simpleTimeZone;
    }

    public static IdIdNameItem getTimeZoneItem(TimeZone timeZone) {
        int n = timeZone.useDaylightTime() ? 1 : 0;
        int n2 = 86400 - timeZone.getRawOffset() / 1000;
        String string = timeZone.getID();
        return new IdIdNameItem(n, n2, string);
    }

    public static String getFormattedDate() {
        return DateUtilities.getFormattedDate(new Date().getTime() / 1000L);
    }

    public static int getNow() {
        return DateUtilities.getUnixTime(new Date());
    }

    public static int getUnixTime(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    public static long getCurrentTimeInMSecs() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() / 1000L;
        long l2 = l * 0x80000000L;
        return l2 + (long)calendar.get(14);
    }

    public static int getCurrentCSTimeSec() {
        Calendar calendar = Calendar.getInstance(DateUtilities.getCommserveTimezone());
        return (int)(calendar.getTimeInMillis() / 1000L);
    }

    static {
        Locale locale = DateUtilities.getUserLocal();
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            String string = "Control Panel\\International";
            systemLongDateFormat = CurrentUserKeyReader.getCurrentUserKeyValue(string, "sLongDate");
            systemLongDateFormat = !DateUtilities.isValidFormat(systemLongDateFormat) ? DateUtilities.getDateFormat(1, locale) : DateUtilities.processDateFormat(systemLongDateFormat);
            systemShortDateFormat = CurrentUserKeyReader.getCurrentUserKeyValue(string, "sShortDate");
            if (!DateUtilities.isValidFormat(systemShortDateFormat)) {
                systemShortDateFormat = DateUtilities.getDateFormat(3, locale);
            }
            String string2 = systemTimeFormat = (systemTimeFormat = CurrentUserKeyReader.getCurrentUserKeyValue(string, "sShortTime")) == null ? null : systemTimeFormat.replaceAll("t", "a").replaceAll("T", "a");
            if (!DateUtilities.isValidFormat(systemTimeFormat)) {
                systemTimeFormat = DateUtilities.getTimeFormat(3, locale);
            }
            String string3 = systemLongTimeFormat = (systemLongTimeFormat = CurrentUserKeyReader.getCurrentUserKeyValue(string, "sTimeFormat")) == null ? null : systemLongTimeFormat.replaceAll("t", "a").replaceAll("T", "a");
            if (!DateUtilities.isValidFormat(systemLongTimeFormat)) {
                systemLongTimeFormat = DateUtilities.getTimeFormat(2, locale);
            }
        } else {
            systemLongDateFormat = DateUtilities.getDateFormat(1, locale);
            systemShortDateFormat = DateUtilities.getDateFormat(3, locale);
            systemTimeFormat = DateUtilities.getTimeFormat(3, locale);
            systemLongTimeFormat = DateUtilities.getTimeFormat(2, locale);
        }
        useUserDateFormat = false;
        currentSystemTimeZone = null;
        instance = null;
    }

    public static enum UserTimeZone {
        CS_TimeZone,
        Sys_TimeZone,
        User_TimeZone;

    }
}

