/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.help;

import commvault.cte.help.HelpBroker;
import commvault.cte.help.HelpSet;
import commvault.cte.util.Logger;
import java.io.IOException;
import java.util.logging.Level;

public class HelpManager {
    private HelpBroker mainBroker = new HelpBroker();
    private HelpSet mainHelpSet = new HelpSet();
    private int helpSetCount = 1;
    private static HelpManager instance;

    private HelpManager() {
    }

    public static HelpManager getInstance() {
        if (instance == null) {
            instance = new HelpManager();
        }
        return instance;
    }

    public void resetHelp() {
        this.setCurrentID(null);
    }

    public HelpBroker getHelpBroker() {
        return this.mainBroker;
    }

    public HelpSet getMainHelpSet() {
        return this.mainHelpSet;
    }

    public int getHelpSetCount() {
        return this.helpSetCount;
    }

    public HelpSet getFirstHelpSet() {
        return null;
    }

    public void displayHelp() {
        this.mainBroker.setDisplayed(true);
    }

    public String getCurrentID() {
        return this.mainBroker.getCurrentHelpId();
    }

    public void setCurrentID(String string) {
        this.mainBroker.setCurrentID(string);
    }

    public String checkHelpMap(String string, HelpSet helpSet) {
        return this.mainHelpSet.containsKey(string) ? string : null;
    }

    public void loadHelpSet() {
        try {
            this.mainHelpSet.loadHelpSets();
        }
        catch (IOException iOException) {
            Logger.instance().log(Level.SEVERE, this, "loadHelpSet", "Unable to load Help Set " + iOException.getMessage());
        }
    }
}

