/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.help;

import commvault.cte.common.DesktopBrowserLauncher;
import commvault.cte.help.HelpActionListener;
import commvault.cte.help.HelpSet;
import commvault.cte.util.Logger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class HelpBroker {
    private static final String HELP_PAGE = "Help.aspx";
    private static final String HELP_MODULE = "module=GUI";
    private static final String HELP_PAGE_ID = "id=";
    private String documentationUrl = "";
    private String helpUrl = "";
    private String currentHelpId;

    public void enableHelpKeyForListener(HelpActionListener helpActionListener, String string, HelpSet helpSet) {
    }

    public void enableHelpKey(Component component, String string, HelpSet helpSet) {
    }

    public void setCurrentView(String string) {
    }

    public static Dialog getDialogWithCurrentFocus() {
        Window window;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager != null && (window = keyboardFocusManager.getActiveWindow()) != null && window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            return dialog;
        }
        return null;
    }

    public String getCurrentHelpId() {
        return this.currentHelpId;
    }

    public void setCurrentID(String string) {
        this.currentHelpId = string;
    }

    public void setDisplayed(boolean bl) {
        Object[] objectArray = new Object[]{"Help Id: " + this.currentHelpId};
        Logger.instance().println(objectArray);
        if (bl) {
            this.openHelp();
            this.setCurrentID(null);
        }
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String string) {
        this.documentationUrl = string;
        int n = string.lastIndexOf("/");
        if (n > 0) {
            this.helpUrl = string.substring(0, n + 1);
        }
        this.helpUrl = this.helpUrl + HELP_PAGE;
        Object[] objectArray = new Object[]{"Help URL : " + this.helpUrl};
        Logger.instance().println(objectArray);
    }

    public String getHelpUrl() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.helpUrl);
        stringBuffer.append("?").append(HELP_MODULE);
        try {
            if (this.currentHelpId != null && this.currentHelpId.length() > 0) {
                stringBuffer.append("&").append(HELP_PAGE_ID).append(URLEncoder.encode(this.currentHelpId, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void openURL(String string) {
        try {
            if (string != null && string.length() > 0) {
                DesktopBrowserLauncher.openURL(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void openHelp() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.helpUrl);
            stringBuffer.append("?").append(HELP_MODULE);
            if (this.currentHelpId != null && this.currentHelpId.length() > 0) {
                stringBuffer.append("&").append(HELP_PAGE_ID).append(URLEncoder.encode(this.currentHelpId, "UTF-8"));
            }
            this.openURL(stringBuffer.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

