/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CTEDBTimestamp
extends CTEDBColumn {
    private TimeZone timezone = TimeZone.getDefault();

    public static Timestamp getNow() {
        return new Timestamp(new Date().getTime());
    }

    public static Timestamp fromTimeStamp(Calendar calendar) {
        return new Timestamp(calendar.getTimeInMillis());
    }

    public CTEDBTimestamp(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public CTEDBTimestamp(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl, bl2);
    }

    public Timestamp get() {
        return (Timestamp)this.getValue();
    }

    public void set(Timestamp timestamp) {
        this.setValue(timestamp);
    }

    public void set(Timestamp timestamp, TimeZone timeZone) {
        this.setValue(timestamp);
        this.timezone = timeZone;
    }

    @Override
    protected void fromResult(ResultSet resultSet) throws CTEDBException {
        try {
            this.set(resultSet.getTimestamp(this.getColumnName()));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving timestamp value from result set for column [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet, int n) throws CTEDBException {
        try {
            this.set(resultSet.getTimestamp(n));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving timestamp value from result set for column index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void setParameter(PreparedStatement preparedStatement, int n) throws CTEDBException {
        try {
            preparedStatement.setTimestamp(n, this.get(), Calendar.getInstance(this.timezone));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error adding timestamp parameter [" + this.get() + "] for index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void zero() {
    }
}

