/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CTEDBLong
extends CTEDBColumn {
    public CTEDBLong(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public CTEDBLong(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl, bl2);
    }

    public Long get() {
        return (Long)this.getValue();
    }

    public Long getLongValue() {
        if (this.getValue() == null) {
            return 0L;
        }
        return this.get();
    }

    public void set(Long l) {
        this.setValue(l);
    }

    @Override
    protected void fromResult(ResultSet resultSet) throws CTEDBException {
        try {
            this.set(resultSet.getLong(this.getColumnName()));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving long value from result set for column [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet, int n) throws CTEDBException {
        try {
            this.set(resultSet.getLong(n));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving long value from result set for column index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void setParameter(PreparedStatement preparedStatement, int n) throws CTEDBException {
        try {
            if (this.get() == null) {
                preparedStatement.setNull(n, -5);
            } else {
                preparedStatement.setLong(n, this.get());
            }
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error adding long parameter [" + this.get() + "] for index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void zero() {
        this.set(0L);
    }
}

