/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import commvault.cte.component.CVFrame;
import commvault.cte.component.StatusMessage;
import commvault.cte.component.events.ParentPropertyChangedListener;
import commvault.cte.component.tree.CommNetTreeNodeLock;
import commvault.cte.net.IdNameItem;
import commvault.cte.util.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CommNetTreeNode
extends DefaultMutableTreeNode {
    public static Icon DIRECTORY_ICON = UIManager.getIcon("FileView.directoryIcon");
    int visibility;
    boolean isMarkedForDelete;
    protected String toolTipText;
    protected Icon treeIcon = DIRECTORY_ICON;
    protected CommNetTreeNodeLock lock = null;
    boolean allPopulate = true;
    protected Vector<ParentPropertyChangedListener> listeners = null;
    int observer;
    protected boolean isVirgin = true;
    protected boolean isLoading;
    protected long Id;
    protected String name_ = "";
    protected boolean isExpanded = false;
    protected boolean isInitialUpdate = true;
    protected boolean isUnregistered = false;
    protected IdNameItem idNameItem;
    protected Map<IdNameItem, Integer> idNameItemMap = new HashMap<IdNameItem, Integer>();

    public CommNetTreeNode() {
        this.children = new Vector();
    }

    public CommNetTreeNode(String string) {
        super(string);
        this.children = new Vector();
        this.name_ = string;
    }

    public CommNetTreeNode(String string, boolean bl) {
        this(string);
        this.setAllowsChildren(bl);
    }

    public CommNetTreeNode(int n, String string, boolean bl) {
        this(string, bl);
        this.Id = n;
    }

    public void gc() {
        this.treeIcon = null;
        this.lock = null;
        this.listeners = null;
    }

    public Icon getTreeIcon() {
        if (this.treeIcon == null) {
            return null;
        }
        if (this.treeIcon instanceof ImageIcon && ((ImageIcon)this.treeIcon).getImageLoadStatus() == 8) {
            return this.treeIcon;
        }
        if (this.treeIcon instanceof ImageIcon && (((ImageIcon)this.treeIcon).getImageLoadStatus() == 2 || ((ImageIcon)this.treeIcon).getImageLoadStatus() == 4)) {
            this.treeIcon = null;
        }
        return this.treeIcon;
    }

    public void setTreeIcon(Icon icon) {
        this.treeIcon = icon;
        if (this.treeIcon == null) {
            return;
        }
        if (this.treeIcon instanceof ImageIcon && (((ImageIcon)this.treeIcon).getImageLoadStatus() == 2 || ((ImageIcon)this.treeIcon).getImageLoadStatus() == 4)) {
            this.treeIcon = null;
        }
    }

    public IdNameItem getIdNameItem() {
        if (this.idNameItem == null) {
            this.idNameItem = new IdNameItem((int)this.Id, this.toString());
        }
        return this.idNameItem;
    }

    public int getId() {
        return (int)this.Id;
    }

    public void setId(int n) {
        this.Id = n;
        if (this.idNameItem == null) {
            this.idNameItem = new IdNameItem((int)this.Id, this.toString());
        } else {
            this.idNameItem.setId((int)this.Id);
            this.idNameItem.setName(this.toString());
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String string) {
        this.setUserObject(string);
        this.name_ = string;
        if (this.idNameItem == null) {
            this.idNameItem = new IdNameItem((int)this.Id, this.toString());
        } else {
            this.idNameItem.setId((int)this.Id);
            this.idNameItem.setName(this.toString());
        }
        this.notifyAllExplorers(-7);
    }

    public void gumRefresh() {
        CommNetTreeNode commNetTreeNode = (CommNetTreeNode)this.getParent();
        if (commNetTreeNode == null) {
            return;
        }
        commNetTreeNode.reloadChildren();
    }

    public synchronized void reloadChildren() {
        this.removeAll();
        this.setVirgin(true);
        this.notifyAllExplorers(-1);
        if (this.isVirgin && !this.isLoading) {
            this.isLoading = true;
            this.notifyAllExplorers(-30);
            this.loadChildren();
        }
    }

    public void refresh(Object object) {
        CVFrame.getInstance().setFullBusyCursor();
        CommNetTreeNode commNetTreeNode = (CommNetTreeNode)this.getParent();
        if (commNetTreeNode != null) {
            commNetTreeNode.removeAll();
            commNetTreeNode.setVirgin(true);
            commNetTreeNode.populate();
        }
        CVFrame.getInstance().resetFullBusyCursor();
    }

    public void reloadGrandChildren() {
        int n = this.getChildCount();
        CommNetTreeNode commNetTreeNode = null;
        for (int i = 0; i < n; ++i) {
            commNetTreeNode = (CommNetTreeNode)this.getChildAt(i);
            commNetTreeNode.removeAll();
            commNetTreeNode.setVirgin(true);
            commNetTreeNode.notifyAllExplorers(-1);
            commNetTreeNode.loadChildren();
        }
    }

    public void setVirgin(boolean bl) {
        this.isVirgin = bl;
    }

    public void cancelLock() {
    }

    public int getLockHandle() {
        return this.lock.getLockHandle();
    }

    public void setLockHandle(int n) {
        this.lock.setLockHandle(n);
    }

    protected void notifyAllExplorers(int n) {
    }

    public void exploreAction() {
        this.notifyAllExplorers(-4);
    }

    public void populateAll() {
        this.populate();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((CommNetTreeNode)this.getChildAt(i)).populateAll();
        }
    }

    public void repopulate() {
        this.removeAll();
        this.setVirgin(true);
        this.notifyAllExplorers(-1);
        this.populate();
    }

    public synchronized void waitOnTheNode() {
        try {
            this.wait();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void populate() {
        if (!this.allPopulate) {
            return;
        }
        StatusMessage.setRequestStatusMessage();
        if ((this.isVirgin || this.isLoading) && !this.isLoading) {
            this.isLoading = true;
            this.loadChildren();
            try {
                this.wait(15000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        StatusMessage.resetStatusMessage();
    }

    public synchronized void releaseWaitingThreads() {
        try {
            this.notifyAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void releaseLockOnly() {
        this.isLoading = false;
        this.isVirgin = false;
        try {
            this.notify();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void releaseLock() {
        this.isLoading = false;
        this.isVirgin = false;
        try {
            this.notify();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.notifyAllExplorers(-30);
    }

    public void addObserver(boolean bl) {
        if (bl) {
            ++this.observer;
        } else {
            --this.observer;
            if (this.observer == 0) {
                this.stopUpdate();
            }
        }
    }

    public void expand() {
        this.isExpanded = true;
        if (this.isVirgin && !this.isLoading) {
            this.isLoading = true;
            this.loadChildren();
        }
    }

    public void collapse() {
        this.isExpanded = false;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void selected() {
        if (this.observer == 0) {
            this.resumeUpdate();
        }
    }

    public boolean isVirgin() {
        return this.isVirgin;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    protected void stopUpdate() {
    }

    protected void resumeUpdate() {
    }

    public void loadChildren() {
    }

    public void addUnsorted(CommNetTreeNode commNetTreeNode) {
        if (commNetTreeNode != null) {
            commNetTreeNode.nodeBeingAdded(this);
            super.add(commNetTreeNode);
            this.idNameItemMap.put(commNetTreeNode.getIdNameItem(), super.getChildCount() - 1);
        }
    }

    public void add(CommNetTreeNode commNetTreeNode) {
        this.add(commNetTreeNode, 0);
    }

    public void add(CommNetTreeNode commNetTreeNode, int n) {
        if (commNetTreeNode != null) {
            commNetTreeNode.nodeBeingAdded(this);
            this.addChildInOrder(commNetTreeNode, n);
        }
    }

    void addChildInOrder(CommNetTreeNode commNetTreeNode) {
        this.addChildInOrder(commNetTreeNode, 0);
    }

    void addChildInOrder(CommNetTreeNode commNetTreeNode, int n) {
        boolean bl = false;
        for (int i = n; i < super.getChildCount(); ++i) {
            if (Utils.compareStrings(commNetTreeNode.toString().toLowerCase(), super.getChildAt(i).toString().toLowerCase()) >= 0) continue;
            super.insert(commNetTreeNode, i);
            this.idNameItemMap.put(commNetTreeNode.getIdNameItem(), i);
            bl = true;
            break;
        }
        if (!bl) {
            super.add(commNetTreeNode);
            this.idNameItemMap.put(commNetTreeNode.getIdNameItem(), super.getChildCount() - 1);
        }
    }

    public int getNewChildSortedIndex(CommNetTreeNode commNetTreeNode, int n) {
        int n2;
        int n3;
        for (n3 = n2 = n; n3 < super.getChildCount() && Utils.compareStrings(commNetTreeNode.toString().toLowerCase(), super.getChildAt(n3).toString().toLowerCase()) >= 0; ++n3) {
        }
        n2 = n3;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeNodeChildOnly(CommNetTreeNode commNetTreeNode) {
        Vector vector = this.children;
        synchronized (vector) {
            if (commNetTreeNode != null) {
                commNetTreeNode.nodeBeingAdded(this);
                super.add(commNetTreeNode);
                this.idNameItemMap.put(commNetTreeNode.getIdNameItem(), super.getChildCount() - 1);
            }
        }
    }

    public void sortChildren() {
        this.sortChildren(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null || object.toString() == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object.toString().compareToIgnoreCase(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
    }

    public void sortChildren(Comparator comparator) {
        if (this.children == null) {
            return;
        }
        try {
            Collections.sort(this.children, comparator);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reIndexChildMap();
    }

    protected void reIndexChildMap() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                CommNetTreeNode commNetTreeNode = (CommNetTreeNode)this.children.get(i);
                this.idNameItemMap.put(commNetTreeNode.getIdNameItem(), i);
            }
        }
    }

    public void nodeBeingAdded(CommNetTreeNode commNetTreeNode) {
    }

    public void nodeBeingRemoved(CommNetTreeNode commNetTreeNode) {
    }

    public void remove(CommNetTreeNode commNetTreeNode) {
        commNetTreeNode.nodeBeingRemoved(this);
        this.idNameItemMap.remove(commNetTreeNode.getIdNameItem());
        super.remove(commNetTreeNode);
    }

    public void removeAll() {
        if (this.getChildCount() != 0) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                CommNetTreeNode commNetTreeNode = (CommNetTreeNode)enumeration.nextElement();
                commNetTreeNode.removeAll();
            }
            this.idNameItemMap.clear();
            super.removeAllChildren();
        }
    }

    @Override
    public void removeAllChildren() {
        this.removeAll();
        super.removeAllChildren();
    }

    public void nodeCleanup() {
        CommNetTreeNode commNetTreeNode = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            commNetTreeNode = (CommNetTreeNode)this.getChildAt(i);
            commNetTreeNode.nodeCleanup();
        }
        this.removeAll();
        this.gc();
    }

    public CommNetTreeNode getChildOfName(String string) {
        if (this.idNameItemMap.isEmpty()) {
            this.populate();
        }
        for (IdNameItem idNameItem : this.idNameItemMap.keySet()) {
            if (!idNameItem.getName().equalsIgnoreCase(string)) continue;
            return this.getChild(idNameItem);
        }
        return null;
    }

    public CommNetTreeNode getChildOfIdName(int n, String string) {
        IdNameItem idNameItem = new IdNameItem(n, string);
        return this.getChild(idNameItem);
    }

    public CommNetTreeNode getChild(IdNameItem idNameItem) {
        if (idNameItem == null) {
            return null;
        }
        if (this.idNameItemMap.isEmpty() || !this.idNameItemMap.containsKey(idNameItem)) {
            this.populate();
        }
        Integer n = idNameItem != null ? this.idNameItemMap.get(idNameItem) : null;
        return n != null ? (CommNetTreeNode)this.getChildAt(n) : null;
    }

    public CommNetTreeNode getTreeOnlyChildOfId(int n) {
        if (this.idNameItemMap.isEmpty()) {
            this.populate();
        }
        for (IdNameItem idNameItem : this.idNameItemMap.keySet()) {
            if (idNameItem.getId() != n) continue;
            return this.getChild(idNameItem);
        }
        return null;
    }

    public CommNetTreeNode getTreeOnlyChildOfName(String string) {
        return this.getChildOfName(string);
    }

    public CommNetTreeNode getTreeOnlyChildOfId(Class<?> clazz, int n) {
        CommNetTreeNode commNetTreeNode = this.getChildOfId(n);
        if (clazz == commNetTreeNode.getClass()) {
            return commNetTreeNode;
        }
        return null;
    }

    public CommNetTreeNode getTreeOnlyChildOfName(Class<?> clazz, String string) {
        CommNetTreeNode commNetTreeNode = this.getChildOfName(string);
        if (clazz == commNetTreeNode.getClass()) {
            return commNetTreeNode;
        }
        return null;
    }

    public void addParentPropertyListener(ParentPropertyChangedListener parentPropertyChangedListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(parentPropertyChangedListener)) {
            return;
        }
        this.listeners.addElement(parentPropertyChangedListener);
    }

    public void removeParentPropertyListener(ParentPropertyChangedListener parentPropertyChangedListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(parentPropertyChangedListener);
        }
    }

    protected void fireParentPropertyChangedListener(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, CommNetTreeNode commNetTreeNode) {
        if (this.listeners == null) {
            return;
        }
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ParentPropertyChangedListener parentPropertyChangedListener = (ParentPropertyChangedListener)enumeration.nextElement();
            parentPropertyChangedListener.parentChanged(mutableTreeNode, mutableTreeNode2, commNetTreeNode);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)super.getParent();
        super.setParent(mutableTreeNode);
        if (this.listeners == null) {
            return;
        }
        try {
            this.fireParentPropertyChangedListener((MutableTreeNode)super.getParent(), mutableTreeNode2, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isMarkedForDelete() {
        return this.isMarkedForDelete;
    }

    public void setMarkedForDelete(boolean bl) {
        this.isMarkedForDelete = bl;
    }

    public final void setVisibility(int n) {
        this.visibility = n;
    }

    public int getOrder() {
        return ((CommNetTreeNode)this.getParent()).getOrder();
    }

    public CommNetTreeNode getChildOfId(int n) {
        if (this.idNameItemMap.isEmpty()) {
            this.populate();
        }
        for (IdNameItem idNameItem : this.idNameItemMap.keySet()) {
            if (idNameItem.getId() != n) continue;
            return this.getChild(idNameItem);
        }
        return null;
    }

    public boolean isChildExists(int n) {
        for (IdNameItem idNameItem : this.idNameItemMap.keySet()) {
            if (idNameItem.getId() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isChildExists(String string) {
        for (IdNameItem idNameItem : this.idNameItemMap.keySet()) {
            if (!idNameItem.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildExists(IdNameItem idNameItem) {
        return this.idNameItemMap.containsKey(idNameItem);
    }
}

