/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.EntityContext;
import commvault.cte.component.tree.MultiStateTreeNode;
import commvault.cte.component.tree.NodeState;
import commvault.msgs.CvEntities.EntityType;

public class AlertMultiStateTreeNode
extends MultiStateTreeNode {
    private boolean isClientGroupNode = false;

    public AlertMultiStateTreeNode(Entity entity, EntityContext entityContext, boolean bl) {
        super(entity, entityContext, bl);
        this.setState(entity.isSelected() ? NodeState.Selected : NodeState.NotSelected);
        this.isClientGroupNode = entity.getNodeType().getNodeType() == EntityType.CLIENT_GROUP_ENTITY.getEnumValue();
    }

    public AlertMultiStateTreeNode(Entity entity, EntityContext entityContext) {
        this(entity, entityContext, true);
    }

    @Override
    protected void setParentState(NodeState nodeState) {
        if (!(this.parent instanceof MultiStateTreeNode)) {
            return;
        }
        MultiStateTreeNode multiStateTreeNode = (MultiStateTreeNode)this.parent;
        if (multiStateTreeNode == null || multiStateTreeNode == this.getRoot()) {
            return;
        }
        if (this.isClientGroupNode && nodeState == NodeState.Excluded && !this.areAnySiblingsSelected()) {
            multiStateTreeNode.setNodeState(NodeState.NotSelected);
            multiStateTreeNode.setParentState(NodeState.NotSelected);
        } else {
            super.setParentState(nodeState);
        }
    }

    @Override
    protected NodeState getNextState(NodeState nodeState) {
        if (this.isClientGroupNode) {
            switch (nodeState) {
                case Excluded: {
                    if (this.oldState == NodeState.Selected) {
                        return NodeState.NotSelected;
                    }
                    return NodeState.SelectedBecauseParentIsSelected;
                }
                case Selected: {
                    return NodeState.Excluded;
                }
            }
            return super.getNextState(nodeState);
        }
        return super.getNextState(nodeState);
    }

    @Override
    protected NodeState getNextStateForKids(NodeState nodeState) {
        if (this.isClientGroupNode) {
            switch (nodeState) {
                case Excluded: {
                    if (this.oldState == NodeState.Selected) {
                        return NodeState.NotSelected;
                    }
                    return NodeState.SelectedBecauseParentIsSelected;
                }
                case Selected: {
                    if (this.oldState == NodeState.NotSelected || this.oldState == NodeState.PartiallySelected || this.oldState == NodeState.SelectedWithExclusions) {
                        return NodeState.ExcludedBecauseParentIsExcluded;
                    }
                    return NodeState.SelectedBecauseParentIsSelected;
                }
                case SelectedBecauseParentIsSelected: {
                    if (this.oldState == NodeState.NotSelected) {
                        return NodeState.ExcludedBecauseParentIsExcluded;
                    }
                    return NodeState.ExcludedBecauseParentIsExcluded;
                }
            }
            return super.getNextStateForKids(nodeState);
        }
        return super.getNextStateForKids(nodeState);
    }
}

