/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.link;

import com.jidesoft.swing.NullJideButton;
import commvault.cte.component.table.link.LinkAction;
import commvault.cte.component.table.link.RolloverRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class LinkRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ListCellRenderer,
TreeCellRenderer,
RolloverRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private NullJideButton linkButton = this.createHyperlink();
    private LinkAction<Object> linkAction;
    protected Class<?> targetClass;
    private ImageIcon icon;
    static Dimension dimension = new Dimension(100, 20);

    public LinkRenderer() {
        this(null, null);
    }

    public LinkRenderer(LinkAction linkAction) {
        this(linkAction, null);
    }

    public LinkRenderer(LinkAction linkAction, Class clazz) {
        this(linkAction, clazz, null);
    }

    public LinkRenderer(LinkAction linkAction, Class clazz, ImageIcon imageIcon) {
        this.icon = imageIcon;
        this.linkButton.addActionListener(this.createEditorActionListener());
        this.setLinkAction(linkAction, clazz);
    }

    public void setTargetClass(Class clazz) {
        this.targetClass = clazz;
    }

    public void setLinkAction(LinkAction linkAction) {
        this.setLinkAction(linkAction, null);
    }

    public void setLinkAction(LinkAction linkAction, Class clazz) {
        if (linkAction == null) {
            linkAction = this.createDefaultLinkAction();
        }
        this.setTargetClass(clazz);
        this.linkAction = linkAction;
        this.linkButton.setAction((Action)linkAction);
    }

    public boolean isTargetable(Object object) {
        if (this.targetClass == null) {
            return true;
        }
        if (object == null) {
            return true;
        }
        return this.targetClass.isAssignableFrom(object.getClass());
    }

    protected NullJideButton createHyperlink() {
        NullJideButton nullJideButton = new NullJideButton(){

            public Dimension getPreferredSize() {
                try {
                    return super.getPreferredSize();
                }
                catch (Exception exception) {
                    return dimension;
                }
            }
        };
        nullJideButton.setOpaque(true);
        nullJideButton.setButtonStyle(3);
        nullJideButton.setRolloverEnabled(true);
        nullJideButton.setForeground(Color.blue);
        return nullJideButton;
    }

    protected LinkAction createDefaultLinkAction() {
        return new LinkAction<Object>(null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.err.println("sss");
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void doClick() {
        this.linkButton.doClick();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object != null && !this.isTargetable(object)) {
            object = null;
        }
        this.linkAction.setTarget(object);
        if (jList != null) {
            Point point = (Point)jList.getClientProperty("swingx.rollover");
            if (point != null && point.y >= 0 && point.y == n) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(jList, bl);
            this.updateFocusBorder(bl2);
        }
        this.setIcon();
        return this.linkButton;
    }

    private void updateSelectionColors(JList jList, boolean bl) {
        if (bl) {
            this.linkButton.setBackground(jList.getSelectionBackground());
        } else {
            this.linkButton.setBackground(jList.getBackground());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null && !this.isTargetable(object)) {
            object = null;
        }
        Object object2 = object;
        this.linkAction.setTarget(object2);
        if (jTable != null) {
            Point point = (Point)jTable.getClientProperty("swingx.rollover");
            if (point != null && point.x >= 0 && point.x == n2 && point.y == n) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(jTable, bl);
            this.updateFocusBorder(bl2);
        }
        this.setIcon();
        return this.linkButton;
    }

    private void updateSelectionColors(JTable jTable, boolean bl) {
        if (bl) {
            this.linkButton.setForeground(new Color(255, 255, 255));
            this.linkButton.setBackground(new Color(10, 36, 106));
        } else {
            this.linkButton.setForeground(Color.blue);
            this.linkButton.setBackground(jTable.getBackground());
        }
    }

    private void updateFocusBorder(boolean bl) {
        if (bl) {
            this.linkButton.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.linkButton.setBorder(noFocusBorder);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.linkAction.setTarget(object);
        this.linkButton.getModel().setRollover(true);
        this.updateSelectionColors(jTable, bl);
        this.setIcon();
        return this.linkButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.linkAction.getTarget();
    }

    @Override
    protected void fireEditingStopped() {
        this.fireEditingCanceled();
    }

    private ActionListener createEditorActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkRenderer.this.cancelCellEditing();
            }
        };
        return actionListener;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null && !this.isTargetable(object)) {
            object = null;
        }
        this.linkAction.setTarget(object);
        if (jTree != null) {
            Point point = (Point)jTree.getClientProperty("swingx.rollover");
            if (point != null && point.y >= 0 && point.y == n) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(jTree, bl);
            this.updateFocusBorder(bl4);
        }
        return this.linkButton;
    }

    private void updateSelectionColors(JTree jTree, boolean bl) {
        if (bl) {
            this.linkButton.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.linkButton.setBackground(jTree.getBackground());
        }
    }

    private void setIcon() {
        if (this.linkButton != null && this.icon != null) {
            this.linkButton.setIcon((Icon)this.icon);
        }
    }
}

