/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table.decorator;

import commvault.cte.CteStringBank;
import commvault.cte.component.table.decorator.SortableValue;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class Capacity
implements Comparable,
Serializable,
SortableValue<Long> {
    private static final long serialVersionUID = 1L;
    private long _value = 0L;
    public static Capacity ZERO_CAPACITY = new Capacity(0L);
    private boolean sizeInMB = false;
    private String _text = null;
    private static final String BYTES = CteStringBank.Bytes.getI18n();
    private static final String KB = CteStringBank.KB.getI18n();
    private static final String MB = CteStringBank.MB.getI18n();
    private static final String GB = CteStringBank.GB.getI18n();
    private static final String TB = CteStringBank.TB.getI18n();
    private static final String PB = CteStringBank.PB.getI18n();
    private static final String EB = CteStringBank.EB.getI18n();
    private static final String ZB = CteStringBank.ZB.getI18n();

    public Capacity() {
    }

    public Capacity(long l) {
        this._value = l;
    }

    public Capacity(long l, boolean bl) {
        this._value = l;
        this.sizeInMB = bl;
    }

    public void setValue(long l) {
        this._value = l;
        this._text = null;
    }

    public final int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Capacity capacity = (Capacity)object;
        if (this._value < capacity._value) {
            return -1;
        }
        if (this._value > capacity._value) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        if (this._value < 0L) {
            return "";
        }
        if (this._text == null) {
            Capacity capacity = this;
            synchronized (capacity) {
                if (this._text == null) {
                    this._text = this.sizeInMB ? this.mbFormatValue() : this.formatValue();
                }
            }
        }
        return this._text;
    }

    public final int hashCode() {
        return (int)this._value;
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof Capacity && this._value == ((Capacity)object)._value;
    }

    public final long asLong() {
        return this._value;
    }

    private final String formatValue() {
        String string = null;
        Formatter formatter = null;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        double d = 0.0;
        for (int i = Formatter._formats.length - 1; i >= 0; --i) {
            formatter = Formatter._formats[i];
            long l = formatter.getMinFactor();
            if (this._value < l) continue;
            d = (double)this._value / (double)l;
            string = numberFormat.format(d) + " " + formatter.getUnits();
            return string;
        }
        formatter = Formatter._formats[0];
        string = numberFormat.format(this._value) + " " + formatter.getUnits();
        return string;
    }

    private final String mbFormatValue() {
        String string = null;
        MBFormatter mBFormatter = null;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        double d = 0.0;
        for (int i = MBFormatter._formats.length - 1; i >= 0; --i) {
            mBFormatter = MBFormatter._formats[i];
            long l = mBFormatter.getMinFactor();
            if (this._value < l) continue;
            d = (double)this._value / (double)l;
            string = numberFormat.format(d) + " " + mBFormatter.getUnits();
            return string;
        }
        mBFormatter = MBFormatter._formats[0];
        string = numberFormat.format(this._value) + " " + mBFormatter.getUnits();
        return string;
    }

    @Override
    public Object getObjectFromString(String string) {
        long l = Long.parseLong(string);
        return new Capacity(l);
    }

    @Override
    public String getStringToSaveInFile() {
        return String.valueOf(this._value);
    }

    static /* synthetic */ String access$000() {
        return BYTES;
    }

    static /* synthetic */ String access$100() {
        return KB;
    }

    static /* synthetic */ String access$200() {
        return MB;
    }

    static /* synthetic */ String access$300() {
        return GB;
    }

    static /* synthetic */ String access$400() {
        return TB;
    }

    static /* synthetic */ String access$500() {
        return PB;
    }

    static /* synthetic */ String access$600() {
        return EB;
    }

    static /* synthetic */ String access$700() {
        return ZB;
    }

    public static final class CapacityTableCellRenderer
    extends DefaultTableCellRenderer {
        private static CapacityTableCellRenderer _singleton = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static TableCellRenderer getInstance() {
            if (_singleton != null) return _singleton;
            Class<CapacityTableCellRenderer> clazz = CapacityTableCellRenderer.class;
            synchronized (CapacityTableCellRenderer.class) {
                if (_singleton != null) return _singleton;
                _singleton = new CapacityTableCellRenderer();
                // ** MonitorExit[var0] (shouldn't be in output)
                return _singleton;
            }
        }

        public CapacityTableCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static final class MBFormatter {
        private static final long MULTIPLIER = 1024L;
        public static final MBFormatter[] _formats = new MBFormatter[]{new MBFormatter(0, Capacity.access$200()), new MBFormatter(1, Capacity.access$300()), new MBFormatter(2, Capacity.access$400()), new MBFormatter(3, Capacity.access$500()), new MBFormatter(4, Capacity.access$600()), new MBFormatter(5, Capacity.access$700())};
        private long _minfactor = 1L;
        private final String _units;

        public MBFormatter(int n, String string) {
            this._minfactor = (long)Math.pow(1024.0, n);
            this._units = string;
        }

        public long getMinFactor() {
            return this._minfactor;
        }

        public String getUnits() {
            return this._units;
        }
    }

    public static final class Formatter {
        private static final long MULTIPLIER = 1024L;
        public static final Formatter[] _formats = new Formatter[]{new Formatter(0, Capacity.access$000()), new Formatter(1, Capacity.access$100()), new Formatter(2, Capacity.access$200()), new Formatter(3, Capacity.access$300()), new Formatter(4, Capacity.access$400()), new Formatter(5, Capacity.access$500()), new Formatter(6, Capacity.access$600()), new Formatter(7, Capacity.access$700())};
        private long _minfactor = 1L;
        private final String _units;

        public Formatter(int n, String string) {
            this._minfactor = (long)Math.pow(1024.0, n);
            this._units = string;
        }

        public long getMinFactor() {
            return this._minfactor;
        }

        public String getUnits() {
            return this._units;
        }
    }
}

