/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.component.table.PagedDataLoader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPagedDataLoader<T>
implements PagedDataLoader<T> {
    protected int rowCount = 0;
    protected AbstractTableModel model;
    protected ArrayList<PageData<T>> pagedDatas = new ArrayList();
    public List<T> currentlyViewedData = null;

    public abstract void load(PageData<T> var1) throws Exception;

    @Override
    public void setDataAvailable(int n, int n2) throws Exception {
        if (n == n2 && n == 0) {
            return;
        }
        try {
            this.load(this.getPage(n));
            this.load(this.getPage(n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public ArrayList<PageData<T>> getPagedDatas() {
        return this.pagedDatas;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    protected PageData<T> getPage(int n) {
        for (int i = this.pagedDatas.size() - 1; i >= 0; --i) {
            PageData<T> pageData = this.pagedDatas.get(i);
            if (n - pageData.getRowStart() < 0 || n >= pageData.getRowStart() + pageData.getRowCount()) continue;
            try {
                this.load(pageData);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return pageData;
        }
        return null;
    }

    @Override
    public T getRowAt(int n) {
        PageData<T> pageData = this.getPage(n);
        if (pageData == null || pageData.getDatas() == null || n < pageData.getRowStart() || n >= pageData.getRowStart() + pageData.getDatas().size()) {
            return null;
        }
        this.currentlyViewedData = pageData.getDatas();
        return this.currentlyViewedData.get(n - pageData.getRowStart());
    }

    @Override
    public void loadAll() {
        for (int i = this.pagedDatas.size() - 1; i >= 0; --i) {
            PageData<T> pageData = this.pagedDatas.get(i);
            try {
                this.load(pageData);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setModel(AbstractTableModel abstractTableModel) {
        this.model = abstractTableModel;
    }

    @Override
    public void navigate(String string, Object object) {
    }

    @Override
    public PagedDataLoader<T> getSavingToFileLoader() throws Exception {
        return this;
    }

    @Override
    public int getPage() {
        return 0;
    }

    @Override
    public void setPage(int n) {
    }

    @Override
    public int getNumOfPages() {
        return 0;
    }

    public static class PageData<T> {
        private SoftReference<List<T>> data;
        public int rowStart;
        public int rowCount;

        public int getRowStart() {
            return this.rowStart;
        }

        public PageData<T> copy() {
            PageData<T> pageData = new PageData<T>();
            pageData.rowCount = this.rowCount;
            pageData.rowStart = this.rowStart;
            return pageData;
        }

        public List<T> getDatas() {
            if (this.data == null) {
                return null;
            }
            return this.data.get();
        }

        public int getRowCount() {
            List<T> list = null;
            if (this.data != null) {
                list = this.data.get();
            }
            return this.data == null || list == null ? this.rowCount : list.size();
        }

        public void setDatas(List<T> list) {
            this.data = new SoftReference<List<List<T>>>(list);
        }
    }
}

