/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.internal.utils;

import commvault.cte.component.ribbon.internal.utils.AbstractFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class ColorShiftFilter
extends AbstractFilter {
    int rShift;
    int gShift;
    int bShift;
    double hueShiftAmount;

    public ColorShiftFilter(Color color, double d) {
        this.rShift = color.getRed();
        this.gShift = color.getGreen();
        this.bShift = color.getBlue();
        this.hueShiftAmount = d;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        this.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        this.shiftColor(nArray);
        this.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    private void shiftColor(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = n >>> 16 & 0xFF;
            int n3 = n >>> 8 & 0xFF;
            int n4 = n >>> 0 & 0xFF;
            int n5 = (int)(this.hueShiftAmount * (double)this.rShift + (1.0 - this.hueShiftAmount) * (double)n2);
            int n6 = (int)(this.hueShiftAmount * (double)this.gShift + (1.0 - this.hueShiftAmount) * (double)n3);
            int n7 = (int)(this.hueShiftAmount * (double)this.bShift + (1.0 - this.hueShiftAmount) * (double)n4);
            nArray[i] = n & 0xFF000000 | n5 << 16 | n6 << 8 | n7;
        }
    }
}

