/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.svg;

import commvault.cte.component.ribbon.api.common.AsynchronousLoadListener;
import commvault.cte.component.ribbon.api.common.AsynchronousLoading;
import commvault.cte.component.ribbon.api.common.icon.ResizableIcon;
import commvault.cte.component.ribbon.api.svg.SvgBatikIcon;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.swing.event.EventListenerList;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.util.EventDispatcher;

public class SvgBatikResizableIcon
extends SvgBatikIcon
implements ResizableIcon,
AsynchronousLoading {
    protected EventListenerList listenerList = new EventListenerList();
    static EventDispatcher.Dispatcher asyncCompletedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((AsynchronousLoadListener)object).completed((Boolean)object2);
        }
    };

    protected static InputStream constructFromZipStream(InputStream inputStream) throws IOException {
        int n;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n = gZIPInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static SvgBatikResizableIcon getSvgIcon(URL uRL, Dimension dimension) {
        try {
            return new SvgBatikResizableIcon(uRL.openStream(), dimension);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgIcon(InputStream inputStream, Dimension dimension) {
        if (inputStream == null) {
            return null;
        }
        try {
            return new SvgBatikResizableIcon(inputStream, dimension);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgzIcon(URL uRL, Dimension dimension) {
        try {
            return new SvgBatikResizableIcon(SvgBatikResizableIcon.constructFromZipStream(uRL.openStream()), dimension);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgzIcon(InputStream inputStream, Dimension dimension) {
        try {
            return new SvgBatikResizableIcon(SvgBatikResizableIcon.constructFromZipStream(inputStream), dimension);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private SvgBatikResizableIcon(InputStream inputStream, Dimension dimension) throws IOException {
        super(inputStream, dimension.width, dimension.height);
        this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
                SvgBatikResizableIcon.this.fireAsyncCompleted(true);
            }

            public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
                SvgBatikResizableIcon.this.fireAsyncCompleted(false);
            }
        });
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.setPreferredSize(dimension);
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener asynchronousLoadListener) {
        this.listenerList.add(AsynchronousLoadListener.class, asynchronousLoadListener);
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener asynchronousLoadListener) {
        this.listenerList.remove(AsynchronousLoadListener.class, asynchronousLoadListener);
    }

    @Override
    protected boolean renderGVTTree(int n, int n2) {
        boolean bl = super.renderGVTTree(n, n2);
        if (bl) {
            this.fireAsyncCompleted(true);
        }
        return bl;
    }

    protected void fireAsyncCompleted(Boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AsynchronousLoadListener.class) continue;
            ((AsynchronousLoadListener)objectArray[i + 1]).completed(bl);
        }
    }

    @Override
    public synchronized boolean isLoading() {
        String string = this.getIconWidth() + ":" + this.getIconHeight();
        BufferedImage bufferedImage = (BufferedImage)this.cachedImages.get(string);
        return bufferedImage == null;
    }
}

