/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.common.popup;

import commvault.cte.component.ribbon.api.common.JCommandMenuButton;
import commvault.cte.component.ribbon.api.common.JCommandToggleMenuButton;
import commvault.cte.component.ribbon.api.common.popup.JCommandPopupMenu;
import commvault.cte.component.ribbon.internal.ui.common.popup.JColorSelectorComponent;
import commvault.cte.component.ribbon.internal.ui.common.popup.JColorSelectorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class JColorSelectorPopupMenu
extends JCommandPopupMenu {
    private ColorSelectorCallback colorSelectorCallback;
    private JColorSelectorPanel lastColorSelectorPanel;
    private static LinkedList<Color> recentlySelected = new LinkedList();

    public JColorSelectorPopupMenu(ColorSelectorCallback colorSelectorCallback) {
        this.colorSelectorCallback = colorSelectorCallback;
    }

    public void addColorSectionWithDerived(String string, Color[] colorArray) {
        if (colorArray == null || colorArray.length != 10) {
            throw new IllegalArgumentException("Must pass exactly 10 colors");
        }
        MultiRowSelector multiRowSelector = new MultiRowSelector(colorArray);
        JColorSelectorPanel jColorSelectorPanel = new JColorSelectorPanel(string, multiRowSelector);
        this.addMenuPanel(jColorSelectorPanel);
        this.lastColorSelectorPanel = jColorSelectorPanel;
    }

    public void addColorSection(String string, Color[] colorArray) {
        if (colorArray == null || colorArray.length != 10) {
            throw new IllegalArgumentException("Must pass exactly 10 colors");
        }
        SingleRowSelector singleRowSelector = new SingleRowSelector(colorArray);
        JColorSelectorPanel jColorSelectorPanel = new JColorSelectorPanel(string, singleRowSelector);
        this.addMenuPanel(jColorSelectorPanel);
        this.lastColorSelectorPanel = jColorSelectorPanel;
    }

    public void addRecentSection(String string) {
        SingleRowSelector singleRowSelector = new SingleRowSelector(recentlySelected.toArray(new Color[0]));
        JColorSelectorPanel jColorSelectorPanel = new JColorSelectorPanel(string, singleRowSelector);
        jColorSelectorPanel.setLastPanel(true);
        this.addMenuPanel(jColorSelectorPanel);
        this.lastColorSelectorPanel = jColorSelectorPanel;
    }

    @Override
    public void addMenuButton(JCommandMenuButton jCommandMenuButton) {
        super.addMenuButton(jCommandMenuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    public void addMenuButton(JCommandToggleMenuButton jCommandToggleMenuButton) {
        super.addMenuButton(jCommandToggleMenuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    public void addMenuSeparator() {
        super.addMenuSeparator();
        this.updateLastColorSelectorPanel();
    }

    private void updateLastColorSelectorPanel() {
        if (this.lastColorSelectorPanel != null) {
            this.lastColorSelectorPanel.setLastPanel(true);
            this.lastColorSelectorPanel = null;
        }
    }

    public ColorSelectorCallback getColorSelectorCallback() {
        return this.colorSelectorCallback;
    }

    private static void wireToLRU(JColorSelectorComponent jColorSelectorComponent) {
        jColorSelectorComponent.addColorSelectorCallback(new ColorSelectorCallback(){

            @Override
            public void onColorSelected(Color color) {
                JColorSelectorPopupMenu.addColorToRecentlyUsed(color);
            }

            @Override
            public void onColorRollover(Color color) {
            }
        });
    }

    public static synchronized List<Color> getRecentlyUsedColors() {
        return Collections.unmodifiableList(recentlySelected);
    }

    public static synchronized void addColorToRecentlyUsed(Color color) {
        if (recentlySelected.contains(color)) {
            recentlySelected.remove(color);
            recentlySelected.addLast(color);
            return;
        }
        if (recentlySelected.size() == 10) {
            recentlySelected.removeFirst();
        }
        recentlySelected.addLast(color);
    }

    private class MultiRowSelector
    extends JPanel {
        static final int SECONDARY_ROWS = 5;

        public MultiRowSelector(final Color ... colorArray) {
            final JColorSelectorComponent[][] jColorSelectorComponentArray = new JColorSelectorComponent[colorArray.length][6];
            for (int i = 0; i < colorArray.length; ++i) {
                Color color = colorArray[i];
                jColorSelectorComponentArray[i][0] = new JColorSelectorComponent(color, JColorSelectorPopupMenu.this.colorSelectorCallback);
                JColorSelectorPopupMenu.wireToLRU(jColorSelectorComponentArray[i][0]);
                this.add(jColorSelectorComponentArray[i][0]);
                float[] fArray = new float[3];
                Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
                for (int j = 1; j <= 5; ++j) {
                    float f = (float)(j - 1) / 5.0f;
                    f = (float)Math.pow(f, 1.4f);
                    float f2 = 1.0f - f;
                    if (fArray[1] == 0.0f) {
                        float f3 = 0.5f + 0.5f * fArray[2];
                        f2 = f3 * (float)(5 - j + 1) / 5.0f;
                    }
                    Color color2 = new Color(Color.HSBtoRGB(fArray[0], fArray[1] * (float)(j + 1) / 6.0f, f2));
                    jColorSelectorComponentArray[i][j] = new JColorSelectorComponent(color2, JColorSelectorPopupMenu.this.colorSelectorCallback);
                    jColorSelectorComponentArray[i][j].setTopOpen(j > 1);
                    jColorSelectorComponentArray[i][j].setBottomOpen(j < 5);
                    JColorSelectorPopupMenu.wireToLRU(jColorSelectorComponentArray[i][j]);
                    this.add(jColorSelectorComponentArray[i][j]);
                }
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String string, Component component) {
                }

                @Override
                public void removeLayoutComponent(Component component) {
                }

                @Override
                public Dimension minimumLayoutSize(Container container) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container container) {
                    int n = this.getGap();
                    int n2 = this.getSize();
                    return new Dimension(colorArray.length * n2 + (colorArray.length + 1) * n, n + n2 + n + 5 * n2 + n);
                }

                @Override
                public void layoutContainer(Container container) {
                    int n = this.getGap();
                    int n2 = this.getSize();
                    if (container.getComponentOrientation().isLeftToRight()) {
                        int n3 = n;
                        for (int i = 0; i <= 5; ++i) {
                            int n4 = n;
                            for (int j = 0; j < colorArray.length; ++j) {
                                jColorSelectorComponentArray[j][i].setBounds(n4, n3, n2, n2);
                                n4 += n2 + n;
                            }
                            n3 += n2;
                            if (i != 0) continue;
                            n3 += n;
                        }
                    } else {
                        int n5 = n;
                        for (int i = 0; i <= 5; ++i) {
                            int n6 = MultiRowSelector.this.getWidth() - n;
                            for (int j = 0; j < colorArray.length; ++j) {
                                jColorSelectorComponentArray[j][i].setBounds(n6 - n2, n5, n2, n2);
                                n6 -= n2 + n;
                            }
                            n5 += n2;
                            if (i != 0) continue;
                            n5 += n;
                        }
                    }
                }

                private int getGap() {
                    return 4;
                }

                private int getSize() {
                    return 13;
                }
            });
        }
    }

    private class SingleRowSelector
    extends JPanel {
        public SingleRowSelector(final Color ... colorArray) {
            final JColorSelectorComponent[] jColorSelectorComponentArray = new JColorSelectorComponent[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                jColorSelectorComponentArray[i] = new JColorSelectorComponent(colorArray[i], JColorSelectorPopupMenu.this.colorSelectorCallback);
                JColorSelectorPopupMenu.wireToLRU(jColorSelectorComponentArray[i]);
                this.add(jColorSelectorComponentArray[i]);
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String string, Component component) {
                }

                @Override
                public void removeLayoutComponent(Component component) {
                }

                @Override
                public Dimension minimumLayoutSize(Container container) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container container) {
                    int n = this.getGap();
                    int n2 = this.getSize();
                    return new Dimension(colorArray.length * n2 + (colorArray.length + 1) * n, n2 + 2 * n);
                }

                @Override
                public void layoutContainer(Container container) {
                    int n = this.getGap();
                    int n2 = this.getSize();
                    if (container.getComponentOrientation().isLeftToRight()) {
                        int n3 = n;
                        int n4 = n;
                        for (int i = 0; i < colorArray.length; ++i) {
                            jColorSelectorComponentArray[i].setBounds(n3, n4, n2, n2);
                            n3 += n2 + n;
                        }
                    } else {
                        int n5 = SingleRowSelector.this.getWidth() - n;
                        int n6 = n;
                        for (int i = 0; i < colorArray.length; ++i) {
                            jColorSelectorComponentArray[i].setBounds(n5 - n2, n6, n2, n2);
                            n5 -= n2 + n;
                        }
                    }
                }

                private int getGap() {
                    return 4;
                }

                private int getSize() {
                    return 13;
                }
            });
        }
    }

    public static interface ColorSelectorCallback {
        public void onColorRollover(Color var1);

        public void onColorSelected(Color var1);
    }
}

