/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.progressbar;

import commvault.cte.component.progressbar.CVProgressBarUtils;
import commvault.cte.component.progressbar.CVProgressTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class CVProgressBarUI
extends BasicProgressBarUI {
    private static final int indeterminateStep = 20;
    private static final int determinateAnimationWidth = 120;
    private static AffineTransform moveX = new AffineTransform();
    private Color bgTop = new Color(242, 242, 242);
    private Color bgBottom = new Color(223, 223, 223);
    private Color progressTopColor = Color.WHITE;
    private Color progressBottomColor = new Color(223, 223, 223);
    private Color indeterminateBorder = new Color(210, 210, 210);
    private Color highlightWhite = new Color(255, 255, 255, 180);
    private Color highlightDarkWhite = new Color(255, 255, 255, 210);
    private int round = 4;
    private int innerRound = 2;
    private int shadeWidth = 2;
    private boolean paintIndeterminateBorder = true;
    private int determinateAnimationPause = 1500;
    private int animationLocation = 0;
    private CVProgressTimer animator = null;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new CVProgressBarUI();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getInnerRound() {
        return this.innerRound;
    }

    public void setInnerRound(int n) {
        this.innerRound = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.progressBar);
    }

    public boolean isPaintIndeterminateBorder() {
        return this.paintIndeterminateBorder;
    }

    public void setPaintIndeterminateBorder(boolean bl) {
        this.paintIndeterminateBorder = bl;
    }

    public Color getBgTop() {
        return this.bgTop;
    }

    public void setBgTop(Color color) {
        this.bgTop = color;
    }

    public Color getBgBottom() {
        return this.bgBottom;
    }

    public void setBgBottom(Color color) {
        this.bgBottom = color;
    }

    public Color getProgressTopColor() {
        return this.progressTopColor;
    }

    public void setProgressTopColor(Color color) {
        this.progressTopColor = color;
    }

    public Color getProgressBottomColor() {
        return this.progressBottomColor;
    }

    public void setProgressBottomColor(Color color) {
        this.progressBottomColor = color;
    }

    public Color getIndeterminateBorder() {
        return this.indeterminateBorder;
    }

    public void setIndeterminateBorder(Color color) {
        this.indeterminateBorder = color;
    }

    public Color getHighlightWhite() {
        return this.highlightWhite;
    }

    public void setHighlightWhite(Color color) {
        this.highlightWhite = color;
    }

    public Color getHighlightDarkWhite() {
        return this.highlightDarkWhite;
    }

    public void setHighlightDarkWhite(Color color) {
        this.highlightDarkWhite = color;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        final JProgressBar jProgressBar = (JProgressBar)jComponent;
        jProgressBar.setOpaque(false);
        jProgressBar.setBorderPainted(false);
        jProgressBar.setForeground(Color.DARK_GRAY);
        this.updateBorder(jProgressBar);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CVProgressBarUI.this.updateAnimator(jProgressBar);
            }
        };
        jProgressBar.addPropertyChangeListener("indeterminate", this.propertyChangeListener);
        jProgressBar.addPropertyChangeListener("enabled", this.propertyChangeListener);
        this.updateAnimator(jProgressBar);
        jComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                CVProgressBarUI.this.updateAnimator(jProgressBar);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                CVProgressBarUI.this.updateAnimator(jProgressBar);
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void updateBorder(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth, this.shadeWidth, this.shadeWidth, this.shadeWidth));
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        if (this.animator != null) {
            this.animator.stop();
        }
        super.uninstallUI(jComponent);
    }

    public Shape provideShape() {
        return CVProgressBarUtils.getWebBorderShape(this.progressBar, this.getShadeWidth(), this.getRound());
    }

    private void updateAnimator(final JProgressBar jProgressBar) {
        if (this.animator != null) {
            this.animator.stop();
        }
        if (SwingUtilities.getWindowAncestor(jProgressBar) != null && jProgressBar.isShowing() && jProgressBar.isEnabled()) {
            if (jProgressBar.isIndeterminate()) {
                this.animationLocation = 0;
                this.animator = new CVProgressTimer((long)(1000 / CVProgressBarUtils.animationFps), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (CVProgressBarUI.this.animationLocation < 39) {
                            CVProgressBarUI.this.animationLocation++;
                        } else {
                            CVProgressBarUI.this.animationLocation = 0;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jProgressBar.repaint();
                            }
                        });
                    }
                });
                this.animator.setUseEventDispatchThread(false);
            } else {
                this.animationLocation = -120;
                this.animator = new CVProgressTimer((long)(1000 / CVProgressBarUtils.animationFps), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (CVProgressBarUI.this.animationLocation < CVProgressBarUI.this.getProgressWidth()) {
                            CVProgressBarUI.this.animationLocation = CVProgressBarUI.this.animationLocation + 15;
                            this.refresh(jProgressBar);
                        } else {
                            CVProgressBarUI.this.animationLocation = -120;
                            this.refresh(jProgressBar);
                            CVProgressBarUtils.sleep(CVProgressBarUI.this.determinateAnimationPause);
                        }
                    }

                    private void refresh(final JProgressBar jProgressBar2) {
                        if (!jProgressBar2.isIndeterminate() && jProgressBar2.getValue() > jProgressBar2.getMinimum()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    jProgressBar2.repaint();
                                }
                            });
                        }
                    }
                });
            }
            this.animator.setUseEventDispatchThread(false);
            this.animator.start();
        }
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        Dimension dimension = super.getPreferredInnerHorizontal();
        dimension.width = 240;
        return dimension;
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        Dimension dimension = super.getPreferredInnerVertical();
        dimension.height = 240;
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintProgressBarBorder(jComponent, graphics2D);
        Shape shape = this.getInnerProgressShape(jComponent);
        Shape shape2 = graphics2D.getClip();
        Area area = new Area(shape);
        area.intersect(new Area(shape2));
        graphics2D.setClip(area);
        GeneralPath generalPath = this.getIndeterminateProgressShape(jComponent);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.animationLocation, 0.0);
        generalPath.transform(affineTransform);
        for (int i = 0; i < jComponent.getWidth() - this.shadeWidth * 2 - 4 - 1 + 40; i += 40) {
            graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.progressTopColor, 0.0f, jComponent.getHeight() - this.shadeWidth, this.progressBottomColor));
            graphics2D.fill(generalPath);
            if (this.paintIndeterminateBorder) {
                graphics2D.setPaint(this.indeterminateBorder);
                graphics2D.draw(generalPath);
            }
            generalPath.transform(moveX);
        }
        if (this.progressBar.isStringPainted() && this.progressBar.getString() != null && this.progressBar.getString().trim().length() > 0) {
            int n = graphics2D.getFontMetrics().stringWidth(this.progressBar.getString());
            float f = (float)n / (float)(this.progressBar.getWidth() * 2);
            float f2 = 0.5f - f;
            float f3 = 0.5f + f;
            graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, this.progressBar.getWidth(), 0.0f, new float[]{f2 / 2.0f, f2, f3, f3 + (1.0f - f3) / 2.0f}, new Color[]{CVProgressBarUtils.transparent, this.highlightWhite, this.highlightWhite, CVProgressBarUtils.transparent}));
            graphics2D.fill(shape);
        }
        graphics2D.setClip(shape2);
        if (jComponent.isEnabled()) {
            CVProgressBarUtils.drawShade(graphics2D, shape, CVProgressBarUtils.shadeColor, this.shadeWidth);
        }
        graphics2D.setPaint(jComponent.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
        graphics2D.draw(shape);
        this.drawProgressBarText(graphics2D);
    }

    @Override
    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintProgressBarBorder(jComponent, graphics2D);
        if (this.progressBar.getValue() > this.progressBar.getMinimum()) {
            Shape shape = this.getInnerProgressShape(jComponent);
            if (jComponent.isEnabled()) {
                CVProgressBarUtils.drawShade(graphics2D, shape, CVProgressBarUtils.shadeColor, this.shadeWidth);
            }
            if (this.progressBar.getOrientation() == 0) {
                graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.progressTopColor, 0.0f, jComponent.getHeight() - this.shadeWidth, this.progressBottomColor));
            } else if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                graphics2D.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.progressTopColor, jComponent.getWidth() - this.shadeWidth, 0.0f, this.progressBottomColor));
            } else {
                graphics2D.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.progressBottomColor, jComponent.getWidth() - this.shadeWidth, 0.0f, this.progressTopColor));
            }
            graphics2D.fill(shape);
            if (jComponent.isEnabled()) {
                Shape shape2 = graphics2D.getClip();
                Area area = new Area(shape);
                area.intersect(new Area(shape2));
                graphics2D.setClip(area);
                if (this.progressBar.getOrientation() == 0) {
                    graphics2D.setPaint(new RadialGradientPaint(this.shadeWidth * 2 + this.animationLocation + 60, (float)(this.progressBar.getHeight() / 2), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, CVProgressBarUtils.transparent}));
                } else if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                    graphics2D.setPaint(new RadialGradientPaint(jComponent.getWidth() / 2, (float)(jComponent.getHeight() - this.shadeWidth * 2 - this.animationLocation - 60), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, CVProgressBarUtils.transparent}));
                } else {
                    graphics2D.setPaint(new RadialGradientPaint(jComponent.getWidth() / 2, (float)(this.shadeWidth * 2 + this.animationLocation + 60), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, CVProgressBarUtils.transparent}));
                }
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
            }
            graphics2D.setPaint(jComponent.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
            graphics2D.draw(shape);
        }
        this.drawProgressBarText(graphics2D);
    }

    private void drawProgressBarText(Graphics2D graphics2D) {
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 1) {
                graphics2D.translate(this.progressBar.getWidth() / 2, this.progressBar.getHeight() / 2);
                graphics2D.rotate((double)(this.progressBar.getComponentOrientation().isLeftToRight() ? -1 : 1) * Math.PI / 2.0);
                graphics2D.translate(-this.progressBar.getWidth() / 2, -this.progressBar.getHeight() / 2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = this.progressBar.getString();
            FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
            GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(fontRenderContext, string);
            Rectangle rectangle = glyphVector.getVisualBounds().getBounds();
            if (!this.progressBar.isEnabled()) {
                graphics2D.setPaint(Color.WHITE);
                graphics2D.drawString(string, this.progressBar.getWidth() / 2 - rectangle.width / 2 + 1, this.progressBar.getHeight() / 2 + rectangle.height / 2 - 1 + 1);
            }
            graphics2D.setPaint(this.progressBar.isEnabled() ? this.progressBar.getForeground() : CVProgressBarUtils.disabledTextColor);
            graphics2D.drawString(string, this.progressBar.getWidth() / 2 - rectangle.width / 2, this.progressBar.getHeight() / 2 + rectangle.height / 2 + (this.progressBar.getOrientation() == 1 && !this.progressBar.getComponentOrientation().isLeftToRight() ? -1 : 0));
            if (this.progressBar.getOrientation() == 1) {
                graphics2D.rotate((double)(this.progressBar.getComponentOrientation().isLeftToRight() ? 1 : -1) * Math.PI / 2.0);
            }
        }
    }

    private void paintProgressBarBorder(JComponent jComponent, Graphics2D graphics2D) {
        Shape shape = this.getProgressShape(jComponent);
        if (jComponent.isEnabled()) {
            CVProgressBarUtils.drawShade(graphics2D, shape, CVProgressBarUtils.shadeColor, this.shadeWidth);
        }
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.bgTop, 0.0f, jComponent.getHeight() - this.shadeWidth, this.bgBottom));
        } else {
            graphics2D.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.bgTop, jComponent.getWidth() - this.shadeWidth, 0.0f, this.bgBottom));
        }
        graphics2D.fill(shape);
        graphics2D.setPaint(jComponent.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
        graphics2D.draw(shape);
    }

    private Shape getProgressShape(JComponent jComponent) {
        if (this.round > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, jComponent.getWidth() - this.shadeWidth * 2 - 1, jComponent.getHeight() - this.shadeWidth * 2 - 1, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double(this.shadeWidth, this.shadeWidth, jComponent.getWidth() - this.shadeWidth * 2 - 1, jComponent.getHeight() - this.shadeWidth * 2 - 1);
    }

    private Shape getInnerProgressShape(JComponent jComponent) {
        int n = this.getProgressWidth();
        if (this.progressBar.getOrientation() == 0) {
            if (this.innerRound > 0) {
                return new RoundRectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, n - 1, jComponent.getHeight() - this.shadeWidth * 4 - 1, this.innerRound * 2, this.innerRound * 2);
            }
            return new Rectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, n - 1, jComponent.getHeight() - this.shadeWidth * 4 - 1);
        }
        if (this.progressBar.getComponentOrientation().isLeftToRight()) {
            if (this.innerRound > 0) {
                return new RoundRectangle2D.Double(this.shadeWidth * 2, jComponent.getHeight() - n - this.shadeWidth * 2, jComponent.getWidth() - this.shadeWidth * 4 - 1, n - 1, this.innerRound * 2, this.innerRound * 2);
            }
            return new Rectangle2D.Double(this.shadeWidth * 2, jComponent.getHeight() - n - this.shadeWidth * 2, jComponent.getWidth() - this.shadeWidth * 4 - 1, n - 1);
        }
        if (this.innerRound > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, jComponent.getWidth() - this.shadeWidth * 4 - 1, n - 1, this.innerRound * 2, this.innerRound * 2);
        }
        return new Rectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, jComponent.getWidth() - this.shadeWidth * 4 - 1, n - 1);
    }

    private int getProgressWidth() {
        int n = this.progressBar.isIndeterminate() ? (this.progressBar.getOrientation() == 0 ? this.progressBar.getWidth() - this.shadeWidth * 4 : this.progressBar.getHeight() - this.shadeWidth * 4) : (this.progressBar.getOrientation() == 0 ? (int)((float)(this.progressBar.getWidth() - this.shadeWidth * 4) * ((float)(this.progressBar.getValue() - this.progressBar.getMinimum()) / (float)(this.progressBar.getMaximum() - this.progressBar.getMinimum()))) : (int)((float)(this.progressBar.getHeight() - this.shadeWidth * 4) * ((float)(this.progressBar.getValue() - this.progressBar.getMinimum()) / (float)(this.progressBar.getMaximum() - this.progressBar.getMinimum()))));
        return n;
    }

    private GeneralPath getIndeterminateProgressShape(JComponent jComponent) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(this.shadeWidth * 2 - 40, jComponent.getHeight() - this.shadeWidth - 1);
        generalPath.lineTo(this.shadeWidth * 2 - 20, this.shadeWidth);
        generalPath.lineTo(this.shadeWidth * 2, this.shadeWidth);
        generalPath.lineTo(this.shadeWidth * 2 - 20, jComponent.getHeight() - this.shadeWidth - 1);
        generalPath.closePath();
        return generalPath;
    }

    static {
        moveX.translate(40.0, 0.0);
    }
}

