/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.print;

import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.Utilities;
import commvault.cte.component.print.DataSizeSelectionPanel;
import commvault.cte.component.print.PrintOptions;
import commvault.cte.util.ReportUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class PrintDialog
extends PropertyDialog {
    private JComboBox pageSizeComboBox = new JComboBox();
    private JComboBox zoomComboBox = new JComboBox();
    private JRadioButton portraitRadioButton = new JRadioButton(CteStringBank.Portrait.getI18n(), true);
    private JRadioButton landscapeRadioButton = new JRadioButton(CteStringBank.Landscape.getI18n());
    private JRadioButton clipColumnsRadioButton = new JRadioButton(CteStringBank.Clip_Columns_to_page.getI18n());
    private JRadioButton wrapColumnsRadioButton = new JRadioButton(CteStringBank.Wrap_table_columns_to_same_page.getI18n());
    private JRadioButton wrapColumnsToNextPageRadioButton = new JRadioButton(CteStringBank.Wrap_table_columns_to_next_page.getI18n(), true);
    protected final Utilities.DefaultCapableButton previewButton = new Utilities.DefaultCapableButton(CteStringBank.Preview.getI18n());
    public boolean isPrintSelected = false;
    public boolean isPrintPreviewSelected = false;
    private PrintOptions userPrefOptions = new PrintOptions();
    public DataSizeSelectionPanel selectionPanel;

    public PrintDialog() {
        super((Frame)((Object)CVFrame.instance()), CteStringBank.Print_Options.getI18n(), true);
        this.setResizable(true);
        this.contentPane.removeAll();
        this.contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(CteStringBank.Paper_Size_colon.getI18n());
        jLabel.setDisplayedMnemonic('P');
        jLabel.setLabelFor(this.pageSizeComboBox);
        this.pageSizeComboBox.addItem(CteStringBank.A3.getI18n());
        this.pageSizeComboBox.addItem(CteStringBank.A4.getI18n());
        this.pageSizeComboBox.addItem(CteStringBank.B4.getI18n());
        this.pageSizeComboBox.addItem(CteStringBank.B5.getI18n());
        this.pageSizeComboBox.addItem(CteStringBank.Legal.getI18n());
        this.pageSizeComboBox.addItem(CteStringBank.Letter.getI18n());
        this.pageSizeComboBox.setSelectedItem(CteStringBank.A4.getI18n());
        this.pageSizeComboBox.setPreferredSize(new Dimension(this.pageSizeComboBox.getPreferredSize().width + 10, this.pageSizeComboBox.getPreferredSize().height));
        Utilities.addRow(this.contentPane, (JComponent)jLabel, (JComponent)this.pageSizeComboBox);
        JLabel jLabel2 = new JLabel(CteStringBank.Zoom_colon.getI18n());
        jLabel2.setDisplayedMnemonic('Z');
        jLabel2.setLabelFor(this.zoomComboBox);
        for (int i = 50; i <= 100; i += 10) {
            this.zoomComboBox.addItem(new String(i + "%"));
        }
        this.zoomComboBox.setSelectedItem(new String("70%"));
        this.zoomComboBox.setPreferredSize(new Dimension(this.zoomComboBox.getPreferredSize().width + 10, this.zoomComboBox.getPreferredSize().height));
        Utilities.addRow(this.contentPane, (JComponent)jLabel2, (JComponent)this.zoomComboBox);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this.portraitRadioButton);
        jPanel.add(this.landscapeRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.portraitRadioButton);
        buttonGroup.add(this.landscapeRadioButton);
        jLabel = new JLabel(CteStringBank.Orientation_colon.getI18n());
        jLabel.setDisplayedMnemonic('O');
        jLabel.setLabelFor(jPanel);
        Utilities.addRow(this.contentPane, (JComponent)jLabel, (JComponent)jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(CteStringBank.Table_Overflow_Mode.getI18n()));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.clipColumnsRadioButton);
        buttonGroup.add(this.wrapColumnsRadioButton);
        buttonGroup.add(this.wrapColumnsToNextPageRadioButton);
        jPanel2.add((Component)this.clipColumnsRadioButton, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 15)));
        jPanel2.add((Component)this.wrapColumnsRadioButton, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 15)));
        jPanel2.add((Component)this.wrapColumnsToNextPageRadioButton, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 0, 1.0, 1.0, 17, 2, new Insets(10, 10, 5, 15)));
        this.contentPane.add((Component)jPanel2, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 15)));
        this.selectionPanel = new DataSizeSelectionPanel(true, true);
        this.contentPane.add((Component)new JSeparator(), Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 15)));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 0));
        this.okButton.setText(CteStringBank.Print.getI18n());
        jPanel3.add(this.okButton);
        this.previewButton.addActionListener(this);
        jPanel3.add(this.previewButton);
        jPanel3.add(this.cancelButton);
        jPanel3.add(this.helpButton);
        this.okButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.cancelButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.helpButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.contentPane.add((Component)jPanel3, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 0, 1.0, 1.0, 11, 2, new Insets(15, 5, 5, 5)));
        this.update();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    public void setPageOrientation(int n) {
        if (n == 0) {
            this.portraitRadioButton.setSelected(true);
        } else {
            this.landscapeRadioButton.setSelected(true);
        }
    }

    public boolean setUserPreferences(PrintOptions printOptions) {
        if (printOptions.pageOrientation == 0) {
            this.portraitRadioButton.setSelected(true);
        } else {
            this.landscapeRadioButton.setSelected(true);
        }
        this.pageSizeComboBox.setSelectedItem(printOptions.paperSize);
        if (printOptions.zoom > 0) {
            this.setZoom(printOptions.zoom);
        } else {
            this.setZoom(70);
        }
        this.userPrefOptions.reportType = printOptions.reportType;
        this.update();
        return true;
    }

    public boolean update() {
        this.userPrefOptions.pageOrientation = this.portraitRadioButton.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1);
        if (this.pageSizeComboBox.getSelectedItem() == null) {
            return false;
        }
        this.userPrefOptions.paperSize = (String)this.pageSizeComboBox.getSelectedItem();
        this.userPrefOptions.zoom = this.getZoom();
        return true;
    }

    public boolean update(PrintOptions printOptions) {
        this.update();
        printOptions.pageOrientation = this.userPrefOptions.pageOrientation;
        printOptions.paperSize = this.userPrefOptions.paperSize;
        printOptions.zoom = this.userPrefOptions.zoom;
        printOptions.tableOverflowMode = this.userPrefOptions.tableOverflowMode;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.isPrintSelected = true;
            super.okButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource().equals(this.previewButton)) {
            this.isPrintPreviewSelected = true;
            super.okButtonActionPerformed(actionEvent);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public boolean isLandscape() {
        return this.landscapeRadioButton.isSelected();
    }

    public String getZoomStr() {
        return (String)this.zoomComboBox.getSelectedItem();
    }

    public int getZoom() {
        return ReportUtilities.getScaleFromPercentageString(this.getZoomStr());
    }

    public void setZoom(int n) {
        this.setZoom(new String(n + "%"));
    }

    public void setZoom(String string) {
        this.zoomComboBox.setSelectedItem(string);
    }
}

