/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.text.dialogs.HTMLAttributeEditorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ListAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    public static final int UL_LIST = 0;
    public static final int OL_LIST = 1;
    private static final String UL = HtmleditorStringBank.unorderedList.getI18n();
    private static final String OL = HtmleditorStringBank.orderedList.getI18n();
    private static final String[] LIST_TYPES = new String[]{UL, OL};
    private static final String[] OL_TYPES = new String[]{"1", "a", "A", "i", "I"};
    private static final String[] OL_TYPE_LABELS = new String[]{"1, 2, 3, ...", "a, b, c, ...", "A, B, C, ...", "i, ii, iii, ...", "I, II, III, ..."};
    private static final String[] UL_TYPES = new String[]{"disc", "square", "circle"};
    private static final String[] UL_TYPE_LABELS = new String[]{HtmleditorStringBank.solidCircle.getI18n(), HtmleditorStringBank.solidSquare.getI18n(), HtmleditorStringBank.openCircle.getI18n()};
    private JLabel typeLabel = null;
    private JComboBox typeCombo = null;
    private JComboBox styleCombo = null;
    private JSpinner startAtField = null;
    private JCheckBox styleCB = null;
    private JCheckBox startAtCB = null;

    public ListAttributesPanel() {
        this(new Hashtable());
    }

    public ListAttributesPanel(Hashtable hashtable) {
        this.initialize();
        this.setAttributes(hashtable);
        this.updateComponentsFromAttribs();
    }

    public void setListType(int n) {
        this.typeCombo.setSelectedIndex(n);
        this.updateForType();
    }

    public int getListType() {
        return this.typeCombo.getSelectedIndex();
    }

    private void updateForType() {
        this.styleCombo.removeAllItems();
        if (this.typeCombo.getSelectedItem().equals(UL)) {
            for (int i = 0; i < UL_TYPE_LABELS.length; ++i) {
                this.styleCombo.addItem(UL_TYPE_LABELS[i]);
            }
            this.startAtCB.setEnabled(false);
            this.startAtField.setEnabled(false);
        } else {
            for (int i = 0; i < OL_TYPE_LABELS.length; ++i) {
                this.styleCombo.addItem(OL_TYPE_LABELS[i]);
            }
            this.startAtCB.setEnabled(true);
            this.startAtField.setEnabled(this.startAtCB.isSelected());
        }
    }

    private int getIndexForStyle(String string) {
        if (this.typeCombo.getSelectedIndex() == 0) {
            for (int i = 0; i < UL_TYPES.length; ++i) {
                if (!UL_TYPES[i].equals(string)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < OL_TYPES.length; ++i) {
                if (!OL_TYPES[i].equals(string)) continue;
                return i;
            }
        }
        return 0;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridy = 0;
        this.typeLabel = new JLabel();
        this.typeLabel.setText(HtmleditorStringBank.listType.getI18n());
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(234, 159));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.typeLabel, gridBagConstraints6);
        this.add((Component)this.getTypeCombo(), gridBagConstraints5);
        this.add((Component)this.getStyleCombo(), gridBagConstraints4);
        this.add((Component)this.getStartAtField(), gridBagConstraints3);
        this.add((Component)this.getStyleCB(), gridBagConstraints2);
        this.add((Component)this.getStartAtCB(), gridBagConstraints);
    }

    @Override
    public void updateComponentsFromAttribs() {
        int n;
        if (this.attribs.containsKey("type")) {
            this.styleCB.setSelected(true);
            this.styleCombo.setEnabled(true);
            n = this.getIndexForStyle(this.attribs.get("type").toString());
            this.styleCombo.setSelectedIndex(n);
        } else {
            this.styleCB.setSelected(false);
            this.styleCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("start")) {
            this.startAtCB.setSelected(true);
            this.startAtField.setEnabled(true);
            try {
                n = Integer.parseInt(this.attribs.get("start").toString());
                this.startAtField.getModel().setValue(new Integer(n));
            }
            catch (Exception exception) {}
        } else {
            this.startAtCB.setSelected(false);
            this.startAtField.setEnabled(false);
        }
    }

    @Override
    public void updateAttribsFromComponents() {
        if (this.styleCB.isSelected()) {
            if (this.typeCombo.getSelectedIndex() == 0) {
                this.attribs.put("type", UL_TYPES[this.styleCombo.getSelectedIndex()]);
            } else {
                this.attribs.put("type", OL_TYPES[this.styleCombo.getSelectedIndex()]);
            }
        } else {
            this.attribs.remove("type");
        }
        if (this.startAtCB.isSelected()) {
            this.attribs.put("start", this.startAtField.getModel().getValue().toString());
        } else {
            this.attribs.remove("start");
        }
    }

    private JComboBox getTypeCombo() {
        if (this.typeCombo == null) {
            this.typeCombo = new JComboBox<String>(LIST_TYPES);
            this.typeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ListAttributesPanel.this.updateForType();
                }
            });
        }
        return this.typeCombo;
    }

    private JComboBox getStyleCombo() {
        if (this.styleCombo == null) {
            this.styleCombo = new JComboBox<String>(UL_TYPE_LABELS);
        }
        return this.styleCombo;
    }

    private JSpinner getStartAtField() {
        if (this.startAtField == null) {
            this.startAtField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.startAtField;
    }

    private JCheckBox getStyleCB() {
        if (this.styleCB == null) {
            this.styleCB = new JCheckBox();
            this.styleCB.setText(HtmleditorStringBank.style.getI18n());
            this.styleCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ListAttributesPanel.this.styleCombo.setEnabled(ListAttributesPanel.this.styleCB.isSelected());
                }
            });
        }
        return this.styleCB;
    }

    private JCheckBox getStartAtCB() {
        if (this.startAtCB == null) {
            this.startAtCB = new JCheckBox();
            this.startAtCB.setText(HtmleditorStringBank.startAt.getI18n());
            this.startAtCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ListAttributesPanel.this.startAtField.setEnabled(ListAttributesPanel.this.startAtCB.isSelected());
                }
            });
        }
        return this.startAtCB;
    }
}

