/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.dialogs.HTMLOptionDialog;
import commvault.cte.component.htmleditor.ui.text.dialogs.ImagePanel;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import javax.swing.Icon;

public class ImageDialog
extends HTMLOptionDialog {
    private static final long serialVersionUID = 1L;
    private static Icon icon = UIUtils.getIcon("images/x16/", "image32.png");
    private static String title = HtmleditorStringBank.image.getI18n();
    private static String desc = HtmleditorStringBank.image_desc.getI18n();
    private ImagePanel imagePanel;

    public ImageDialog(Frame frame) {
        super(frame, title, desc, icon);
        this.init();
    }

    public ImageDialog(Dialog dialog) {
        super(dialog, title, desc, icon);
        this.init();
    }

    private void init() {
        this.imagePanel = new ImagePanel();
        this.setContentPane(this.imagePanel);
        this.setSize(300, 345);
        this.setResizable(false);
    }

    public void setImageAttributes(Map map) {
        this.imagePanel.setAttributes(map);
    }

    public Map getImageAttributes() {
        return this.imagePanel.getAttributes();
    }

    private String createImgAttributes(Map map) {
        String string = "";
        for (Object k : map.keySet()) {
            if (k.toString().equals("a") || k.toString().equals("name")) continue;
            string = string + " " + k + "=" + "\"" + map.get(k) + "\"";
        }
        return string;
    }

    @Override
    public String getHTML() {
        Map map = this.imagePanel.getAttributes();
        boolean bl = map.containsKey("a");
        String string = "";
        if (bl) {
            string = "<a " + map.get("a") + ">";
        }
        string = string + "<img" + this.createImgAttributes(map) + ">";
        if (bl) {
            string = string + "</a>";
        }
        return string;
    }
}

