/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class PasteFormattedAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public PasteFormattedAction() {
        super(HtmleditorStringBank.pasteFormatted.getI18n());
        this.putValue("MnemonicKey", new Integer(70));
        this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "paste.png"));
        this.putValue("LARGE_ICON", UIUtils.getIcon("images/x24/", "paste.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl V"));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                if (PasteFormattedAction.this.getCurrentEditor() == null) {
                    return false;
                }
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents((Object)PasteFormattedAction.this);
                if (transferable == null) {
                    return false;
                }
                DataFlavor dataFlavor = DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors());
                return dataFlavor != null && dataFlavor.getMimeType().startsWith("text/html");
            }
        });
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        String string = null;
        try {
            string = this.getHTMLFragment();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            CompoundUndoManager.beginCompoundEdit(jEditorPane.getDocument());
            jEditorPane.replaceSelection(string);
            CompoundUndoManager.endCompoundEdit(jEditorPane.getDocument());
        }
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        String string = null;
        try {
            string = this.getHTMLFragment();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            CompoundUndoManager.beginCompoundEdit(jEditorPane.getDocument());
            HTMLUtils.insertArbitraryHTML(string, jEditorPane);
            CompoundUndoManager.endCompoundEdit(jEditorPane.getDocument());
        }
    }

    private String getHTMLFragment() throws IOException, UnsupportedFlavorException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents((Object)this);
        if (transferable == null) {
            return null;
        }
        DataFlavor dataFlavor = DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors());
        if (!dataFlavor.getMimeType().startsWith("text/html")) {
            return null;
        }
        String string = this.read(dataFlavor.getReaderForText(transferable));
        int n = 66;
        Pattern pattern = Pattern.compile("<\\s*body\\b([^<>]*)>", n);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = string.substring(matcher.end(), string.length());
        }
        if ((matcher = (pattern = Pattern.compile("<\\s*/\\s*body\\s*>", n)).matcher(string)).find()) {
            string = string.substring(0, matcher.start());
        }
        string = string.replaceAll("<\\!\\-\\-StartFragment\\-\\->", "");
        string = string.replaceAll("<\\!\\-\\-EndFragment\\-\\->", "");
        String string2 = "<([^>]*)(?:class|id)\\s*=\\s*(?:'[^']*'|\"\"[^\"\"]*\"\"|[^\\s>]+)([^>]*)>";
        pattern = Pattern.compile(string2, n);
        matcher = pattern.matcher(string);
        string = matcher.replaceAll("<$1$2>");
        matcher = pattern.matcher(string);
        string = matcher.replaceAll("<$1$2>");
        return string;
    }

    public String read(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuffer.toString();
    }
}

