/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.ui.DefaultAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public abstract class HTMLTextEditAction
extends DefaultAction {
    public static final String EDITOR = "editor";
    public static final int DISABLED = -1;
    public static final int WYSIWYG = 0;
    public static final int SOURCE = 1;

    public HTMLTextEditAction(String string) {
        super(string);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                return HTMLTextEditAction.this.getEditMode() != -1;
            }
        });
        this.updateEnabledState();
    }

    public void execute(ActionEvent actionEvent) throws Exception {
        if (this.getEditMode() == 0) {
            this.wysiwygEditPerformed(actionEvent, this.getCurrentEditor());
        } else if (this.getEditMode() == 1) {
            this.sourceEditPerformed(actionEvent, this.getCurrentEditor());
        }
    }

    public int getEditMode() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        if (jEditorPane.getDocument() instanceof HTMLDocument && jEditorPane.getEditorKit() instanceof HTMLEditorKit) {
            return 0;
        }
        return 1;
    }

    protected JEditorPane getCurrentEditor() {
        try {
            JEditorPane jEditorPane = (JEditorPane)this.getContextValue(EDITOR);
            return jEditorPane;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    protected void actionPerformedCatch(Throwable throwable) {
        throwable.printStackTrace();
    }

    protected void contextChanged() {
        if (this.getEditMode() == 0) {
            this.updateWysiwygContextState(this.getCurrentEditor());
        } else if (this.getEditMode() == 1) {
            this.updateSourceContextState(this.getCurrentEditor());
        }
    }

    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
    }

    protected void updateSourceContextState(JEditorPane jEditorPane) {
    }

    protected abstract void wysiwygEditPerformed(ActionEvent var1, JEditorPane var2);

    protected abstract void sourceEditPerformed(ActionEvent var1, JEditorPane var2);
}

