/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import commvault.cte.component.htmleditor.ui.text.dialogs.HyperlinkDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;

public class HTMLLinkAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLLinkAction() {
        super(HtmleditorStringBank.hyperlink1.getI18n());
        this.putValue("MnemonicKey", new Integer(108));
        this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "link.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HyperlinkDialog hyperlinkDialog = this.createDialog(jEditorPane);
        if (hyperlinkDialog == null) {
            return;
        }
        hyperlinkDialog.setLocationRelativeTo(hyperlinkDialog.getParent());
        hyperlinkDialog.setLinkText(jEditorPane.getSelectedText());
        hyperlinkDialog.setVisible(true);
        if (hyperlinkDialog.hasUserCancelled()) {
            return;
        }
        jEditorPane.requestFocusInWindow();
        jEditorPane.replaceSelection(hyperlinkDialog.getHTML());
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HyperlinkDialog hyperlinkDialog = this.createDialog(jEditorPane);
        if (hyperlinkDialog == null) {
            return;
        }
        if (jEditorPane.getSelectedText() != null) {
            hyperlinkDialog.setLinkText(jEditorPane.getSelectedText());
        }
        hyperlinkDialog.setLocationRelativeTo(hyperlinkDialog.getParent());
        hyperlinkDialog.setVisible(true);
        if (hyperlinkDialog.hasUserCancelled()) {
            return;
        }
        String string = hyperlinkDialog.getHTML();
        if (jEditorPane.getSelectedText() == null) {
            string = string + "&nbsp;";
        }
        jEditorPane.replaceSelection("");
        HTMLUtils.insertHTML(string, HTML.Tag.A, jEditorPane);
        hyperlinkDialog = null;
    }

    protected HyperlinkDialog createDialog(JTextComponent jTextComponent) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        HyperlinkDialog hyperlinkDialog = null;
        if (window != null && window instanceof Frame) {
            hyperlinkDialog = new HyperlinkDialog((Frame)window);
        } else if (window != null && window instanceof Dialog) {
            hyperlinkDialog = new HyperlinkDialog((Dialog)window);
        }
        return hyperlinkDialog;
    }
}

