/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLLineBreakAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLLineBreakAction() {
        super(HtmleditorStringBank.lineBreak.getI18n());
        this.putValue("MnemonicKey", new Integer(110));
        this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "br.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 1));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        jEditorPane.replaceSelection("<br>\n");
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        int n = jEditorPane.getCaretPosition();
        String string = hTMLDocument.getParagraphElement(n).getName();
        HTML.Tag tag = HTML.getTag(string);
        if (string.toUpperCase().equals("P-IMPLIED")) {
            tag = HTML.Tag.IMPLIED;
        }
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertBR", "<br>", tag, HTML.Tag.BR);
        insertHTMLTextAction.actionPerformed(actionEvent);
    }
}

