/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text;

import java.io.Writer;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;

public class ElementWriter
extends HTMLWriter {
    private Element root;

    private static int getStartPos(Element element, int n) {
        if (n >= element.getStartOffset() && n <= element.getEndOffset()) {
            return n;
        }
        return element.getStartOffset();
    }

    private static int getEndPos(Element element, int n) {
        if (n >= element.getStartOffset() && n <= element.getEndOffset()) {
            return n;
        }
        return element.getEndOffset();
    }

    public ElementWriter(Writer writer, Element element) {
        this(writer, element, element.getStartOffset(), element.getEndOffset());
    }

    public ElementWriter(Writer writer, Element element, int n, int n2) {
        super(writer, (HTMLDocument)element.getDocument(), ElementWriter.getStartPos(element, n), Math.min(element.getDocument().getLength(), ElementWriter.getEndPos(element, n2) - ElementWriter.getStartPos(element, n)));
        this.root = element;
        this.setLineLength(Integer.MAX_VALUE);
    }

    @Override
    protected boolean synthesizedElement(Element element) {
        return element.getStartOffset() < this.getStartOffset() || ElementWriter.isAncestor(element, this.root) || super.synthesizedElement(element);
    }

    private static boolean isAncestor(Element element, Element element2) {
        for (Element element3 = element2.getParentElement(); element3 != null; element3 = element3.getParentElement()) {
            if (element3 != element) continue;
            return true;
        }
        return false;
    }
}

