/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.filechooser;

import commvault.cte.util.Logger;
import java.io.File;
import java.io.IOException;

public class ServerFile
extends File {
    protected boolean isDirectory = false;
    protected long size = 0L;
    private boolean isRoot = false;
    private String parentPath = null;
    String path;

    public ServerFile(String string) {
        super(string);
        this.path = string;
        int n = string.lastIndexOf("/");
        if (n != -1) {
            Logger.instance().println("path : " + string);
            if (string.equals("/")) {
                return;
            }
            this.parentPath = n == 0 ? "/" : string.substring(0, n);
            Logger.instance().println("parent path: " + this.parentPath);
        }
    }

    public ServerFile(File file) {
        this(file.toString());
    }

    public ServerFile(String string, String string2) {
        this(new File(string, string2));
    }

    public ServerFile(String string, boolean bl) {
        this(string);
        this.setDirectory(bl);
    }

    public ServerFile(File file, boolean bl) {
        this(file.toString());
        this.setDirectory(bl);
    }

    public ServerFile(String string, String string2, boolean bl) {
        this(string, string2);
        this.setDirectory(bl);
    }

    public ServerFile(File file, String string, boolean bl) {
        this(ServerFile.appendFileToDir(file.toString(), string));
        this.setDirectory(bl);
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new IOException("Unable to create file at the server");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public long lastModified() {
        return super.lastModified();
    }

    @Override
    public boolean setLastModified(long l) {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return false;
    }

    public void setDirectory(boolean bl) {
        this.isDirectory = bl;
        if (!bl) {
            this.isRoot = false;
        }
    }

    public void setSize(long l) {
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String string) {
        this.parentPath = string;
    }

    @Override
    public long length() {
        return this.getSize();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.getCanonicalFile().toString();
    }

    @Override
    public File getParentFile() {
        if (this.getParentPath() != null) {
            ServerFile serverFile = new ServerFile(this.getParentPath());
            serverFile.setDirectory(true);
            return serverFile;
        }
        File file = new File(this.toString());
        if (file.getAbsoluteFile().getParentFile() == null) {
            return null;
        }
        ServerFile serverFile = new ServerFile(file.getAbsoluteFile().getParentFile());
        serverFile.setDirectory(true);
        return serverFile;
    }

    @Override
    public String getParent() {
        ServerFile serverFile = (ServerFile)this.getParentFile();
        if (serverFile == null) {
            return null;
        }
        return serverFile.toString();
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public void setRoot(boolean bl) {
        this.isRoot = bl;
        if (bl) {
            this.isDirectory = true;
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public ServerFile appendFile(String string) {
        return new ServerFile(ServerFile.appendFileToDir(this.path, string));
    }

    public static String appendFileToDir(String string, String string2) {
        String string3 = "\\";
        if (string.indexOf("/") > -1) {
            string3 = "/";
        }
        return string + string3 + string2;
    }
}

