/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.filechooser;

import commvault.cte.component.filechooser.ServerFile;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.filechooser.FileFilter;

public class OpenFileDirModel
extends AbstractListModel
implements Comparator {
    private FileFilter filter = null;
    private ArrayList fileVector = new ArrayList();
    private int size = 0;
    private Comparator currentComparator = null;
    private int noOfDirectories = 0;

    public OpenFileDirModel() {
        this(null, null);
    }

    public OpenFileDirModel(FileFilter fileFilter) {
        this(fileFilter, null);
    }

    public OpenFileDirModel(Comparator comparator) {
        this(null, comparator);
    }

    public OpenFileDirModel(FileFilter fileFilter, Comparator comparator) {
        this.filter = fileFilter;
        this.setComparator(comparator);
    }

    public void setFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
        if (fileFilter != null && (fileFilter.toString().equals("*") || fileFilter.toString().equals("*.*"))) {
            fileFilter = null;
        }
        int n = this.getSize();
        this.recalculateSize();
        super.fireContentsChanged(this, 0, n);
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    private void recalculateSize() {
        this.noOfDirectories = -1;
        if (this.filter == null) {
            this.size = this.fileVector.size();
            return;
        }
        this.size = 0;
        this.noOfDirectories = 0;
        for (int i = 0; i < this.fileVector.size(); ++i) {
            ServerFile serverFile = (ServerFile)this.fileVector.get(i);
            if (serverFile.isDirectory()) {
                ++this.noOfDirectories;
                ++this.size;
                continue;
            }
            if (!this.filter.accept(serverFile)) continue;
            ++this.size;
        }
    }

    @Override
    public int getSize() {
        if (this.filter == null) {
            return this.fileVector.size();
        }
        return this.size;
    }

    @Override
    public Object getElementAt(int n) {
        if (this.filter == null) {
            return this.fileVector.get(n);
        }
        if (this.noOfDirectories > 0 && n < this.noOfDirectories) {
            return this.fileVector.get(n);
        }
        int n2 = -1;
        int n3 = 0;
        if (this.noOfDirectories > 0) {
            n3 = this.noOfDirectories;
            n2 = this.noOfDirectories - 1;
        }
        while (n3 < this.fileVector.size()) {
            ServerFile serverFile = (ServerFile)this.fileVector.get(n3);
            if (serverFile.isDirectory() || this.filter.accept(serverFile)) {
                ++n2;
            }
            if (n2 == n) {
                return serverFile;
            }
            ++n3;
        }
        return null;
    }

    public void addElements(ServerFile[] serverFileArray) {
        for (int i = 0; i < serverFileArray.length; ++i) {
            this.addElementSorted(serverFileArray[i]);
        }
        this.recalculateSize();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void addElement(ServerFile serverFile) {
        this.addElementSorted(serverFile);
        this.recalculateSize();
    }

    public void setComparator(Comparator comparator) {
        this.currentComparator = comparator;
    }

    public Comparator getComparator() {
        return this.currentComparator;
    }

    private void addElementSorted(ServerFile serverFile) {
        serverFile.getName();
        Comparator comparator = this.getComparator();
        if (comparator == null) {
            comparator = this;
        }
        for (int i = 0; i < this.fileVector.size(); ++i) {
            if (comparator.compare(serverFile, this.fileVector.get(i)) >= 0) continue;
            this.fileVector.add(i, serverFile);
            return;
        }
        this.fileVector.add(serverFile);
    }

    public void removeElement(Object object) {
        this.fileVector.remove(object);
        this.recalculateSize();
    }

    public void removeAllElements() {
        this.size = 0;
        this.noOfDirectories = 0;
        this.fileVector.clear();
        int n = this.getSize();
        this.fireContentsChanged(this, 0, n);
    }

    public ServerFile getFile(String string) {
        for (int i = 0; i < this.fileVector.size(); ++i) {
            if (!((ServerFile)this.fileVector.get(i)).getName().equalsIgnoreCase(string)) continue;
            return (ServerFile)this.fileVector.get(i);
        }
        return null;
    }

    public int getFileIndex(String string) {
        for (int i = 0; i < this.fileVector.size(); ++i) {
            if (!((ServerFile)this.fileVector.get(i)).getName().toLowerCase().startsWith(string.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public ServerFile getFileObject(String string) {
        for (int i = 0; i < this.fileVector.size(); ++i) {
            if (!((ServerFile)this.fileVector.get(i)).getName().toLowerCase().startsWith(string.toLowerCase())) continue;
            return (ServerFile)this.fileVector.get(i);
        }
        return null;
    }

    public int compare(Object object, Object object2) {
        ServerFile serverFile = (ServerFile)object;
        ServerFile serverFile2 = (ServerFile)object2;
        if (serverFile.isDirectory() && !serverFile2.isDirectory()) {
            return -1;
        }
        if (serverFile2.isDirectory() && !serverFile.isDirectory()) {
            return 1;
        }
        return serverFile.getName().toString().toLowerCase().compareTo(serverFile2.getName().toString().toLowerCase());
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }
}

