/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.events;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class JXTitledSeparator
extends JPanel {
    private JLabel label;
    private JSeparator leftSeparator;
    private JSeparator rightSeparator;

    public JXTitledSeparator(String string) {
        this();
        this.setTitle(string);
    }

    public JXTitledSeparator() {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel("");
        this.leftSeparator = new JSeparator();
        this.rightSeparator = new JSeparator();
        this.layoutSeparator();
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.max(dimension.width, 50);
        dimension.height = 20;
        this.setPreferredSize(dimension);
        this.label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.label.setFont(UIManager.getFont("TitledBorder.font"));
    }

    private void layoutSeparator() {
        this.removeAll();
        switch (this.label.getHorizontalAlignment()) {
            case 2: 
            case 7: 
            case 10: {
                this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                this.add((Component)this.rightSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            default: {
                this.add((Component)this.leftSeparator, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.setOpaque(false);
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        this.label.setText(string);
        this.firePropertyChange("title", string2, this.getTitle());
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.getHorizontalAlignment();
        this.label.setHorizontalAlignment(n);
        if (n2 != this.getHorizontalAlignment()) {
            this.layoutSeparator();
        }
        this.firePropertyChange("horizontalAlignment", n2, this.getHorizontalAlignment());
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int n) {
        int n2 = this.getHorizontalTextPosition();
        this.label.setHorizontalTextPosition(n);
        this.firePropertyChange("horizontalTextPosition", n2, this.getHorizontalTextPosition());
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.getIcon();
        this.label.setIcon(icon);
        this.firePropertyChange("icon", icon2, this.getIcon());
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    @Override
    public void setForeground(Color color) {
        if (this.label != null) {
            this.label.setForeground(color);
        }
        super.setForeground(color);
    }
}

