/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import commvault.cte.component.CVFrame;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class CVDockableFrameManager {
    private DockingManager dockMgr;
    private DockableBarManager dockBarMgr;
    private int independentFrameSuffix;
    private Set<String> alwaysAvailable = new HashSet<String>();
    private String activeFeatureId;
    private ArrayList<String> usedKeys = new ArrayList();
    private static CVDockableFrameManager factory;

    public CVDockableFrameManager() {
        this.dockMgr = CVFrame.instance().getDockingManager();
        this.dockBarMgr = CVFrame.instance().getDockableBarManager();
        this.alwaysAvailable.add(Feature.FeatureType.AGENT_VIEW.toString());
        this.alwaysAvailable.add(Feature.FeatureType.TASK.toString());
        this.alwaysAvailable.add(Feature.FeatureType.COMMCELL_BROWSER.toString());
    }

    public static CVDockableFrameManager getInstance() {
        if (factory == null) {
            factory = new CVDockableFrameManager();
        }
        return factory;
    }

    public void showFrame(FeatureFrame featureFrame) {
        this.showFrame(featureFrame, true);
    }

    public void showFrame(final FeatureFrame featureFrame, boolean bl) {
        Object object;
        String string;
        String string2 = string = featureFrame.getKey();
        if (this.alwaysAvailable.contains(featureFrame)) {
            this.dockMgr.showFrame(string2);
            return;
        }
        for (Object e : this.dockMgr.getAllFrameNames()) {
            FeatureFrame featureFrame2;
            String string3 = e.toString();
            if (!string3.startsWith(string2) || (featureFrame2 = (FeatureFrame)this.dockMgr.getFrame(string3)).isPinned()) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    featureFrame2.setFeature(featureFrame.getFeature());
                    CVDockableFrameManager.this.refreshFrame(featureFrame2);
                }
            });
            return;
        }
        if (featureFrame.getFeature().getFeatureContext().getType() != Feature.FeatureType.USER_COMMUNICATOR) {
            object = this.createKey(string);
            featureFrame.setKey((String)object);
        }
        if (this.activeFeatureId != null && this.dockMgr.getFrame(this.activeFeatureId) != null) {
            this.dockMgr.getFrame(this.activeFeatureId).grabFocus();
            object = this.dockMgr.getContextOf(this.activeFeatureId);
            featureFrame.setInitSide(object.getCurrentDockSide());
            featureFrame.setInitIndex(object.getInitIndex());
        }
        this.dockMgr.addFrame((DockableFrame)featureFrame);
        if (bl) {
            this.showFrame(featureFrame.getKey());
        }
    }

    private String createKey(String string) {
        String string2 = string + this.independentFrameSuffix++;
        if (this.usedKeys.contains(string2)) {
            return this.createKey(string);
        }
        return string2;
    }

    public void showFrame(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVDockableFrameManager.this.dockMgr.showFrame(string, true);
            }
        });
    }

    public void showFrame(DockableFrame dockableFrame) {
        DockingManager dockingManager = this.dockMgr;
        if (!dockingManager.getAllFrameNames().contains(dockableFrame.getKey())) {
            dockingManager.addFrame(dockableFrame);
        }
        this.showFrame(dockableFrame.getKey());
    }

    public void refreshFrame(final DockableFrame dockableFrame) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVDockableFrameManager.this.refreshFrame1(dockableFrame);
                }
            });
        } else {
            this.refreshFrame1(dockableFrame);
        }
    }

    private void refreshFrame1(DockableFrame dockableFrame) {
        dockableFrame.updateUI();
        dockableFrame.invalidate();
        dockableFrame.validate();
        this.dockMgr.notifyFrame(dockableFrame.getKey());
    }

    public void removeFrame(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVDockableFrameManager.this.removeFrame1(string);
                }
            });
        } else {
            this.removeFrame1(string);
        }
    }

    private void removeFrame1(String string) {
        if (!this.alwaysAvailable.contains(string)) {
            this.dockMgr.hideFrame(string);
            this.usedKeys.remove(string);
            this.dockMgr.removeFrame(string);
        }
    }

    public DockingManager getDockMgr() {
        return this.dockMgr;
    }

    public DockableBarManager getDockBarMgr() {
        return this.dockBarMgr;
    }

    public void tileFrames(boolean bl) {
        DockingManager dockingManager = this.getDockMgr();
        List list = dockingManager.getAllFrameNames();
        if (list.size() > 0) {
            ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
            ArrayList<DockableFrame> arrayList2 = new ArrayList<DockableFrame>();
            for (String string : list) {
                if (this.alwaysAvailable.contains(string)) {
                    arrayList2.add(dockingManager.getFrame(string));
                } else {
                    arrayList.add(dockingManager.getFrame(string));
                }
                dockingManager.removeFrame(string, true);
            }
            if (bl) {
                this.tileFrames(arrayList, 2);
            } else {
                this.tileFrames(arrayList, 4);
            }
            for (DockableFrame dockableFrame : arrayList2) {
                dockingManager.addFrame(dockableFrame);
            }
            dockingManager.loadLayoutData();
        }
    }

    private void tileFrames(Collection<DockableFrame> collection, int n) {
        DockingManager dockingManager = this.getDockMgr();
        int n2 = 0;
        for (DockableFrame dockableFrame : collection) {
            if (dockableFrame instanceof FeatureFrame) {
                dockableFrame.dispose();
                dockableFrame = new FeatureFrame(((FeatureFrame)dockableFrame).getFeature());
            }
            dockableFrame.setInitIndex(n2++);
            dockableFrame.setInitSide(n);
            dockingManager.addFrame(dockableFrame);
        }
    }

    public void setActiveFeature(String string) {
        this.activeFeatureId = string;
    }

    public void addUsedKey(String string) {
        this.usedKeys.add(string);
    }

    public void addFrame(DockableFrame dockableFrame) {
        if (!this.getDockMgr().getAllFrameNames().contains(dockableFrame.getKey())) {
            try {
                this.getDockMgr().addFrame(dockableFrame);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void activateNextFrame() {
        DockableFrame dockableFrame = this.dockMgr.getFrame(this.dockMgr.getActiveFrameKey());
        if ((dockableFrame = this.getNextActiveFrame(dockableFrame)) != null) {
            this.dockMgr.activateFrame(dockableFrame.getKey());
        }
    }

    private DockableFrame getNextActiveFrame(DockableFrame dockableFrame) {
        DockableFrame dockableFrame2 = this.dockMgr.getFrame(this.dockMgr.getNextFrame(dockableFrame.getKey()));
        int n = this.dockMgr.getAllFrames().size();
        int n2 = 0;
        while (n2++ < n) {
            if (dockableFrame2 == dockableFrame) {
                return null;
            }
            if (dockableFrame2 == null) {
                this.dockMgr.getFrame(this.dockMgr.getFirstFrameKey());
            }
            if (dockableFrame2.isAutohide() || dockableFrame2.isHidden()) {
                dockableFrame2 = this.dockMgr.getFrame(this.dockMgr.getNextFrame(dockableFrame2.getKey()));
                continue;
            }
            return dockableFrame2;
        }
        return dockableFrame2;
    }

    public ArrayList<String> getUsedKeys() {
        return this.usedKeys;
    }

    public void closeAll() {
        CVFrame.instance().getWorkspace().closeAll();
        this.getUsedKeys().clear();
        this.activeFeatureId = null;
        for (Object e : this.getDockMgr().getAllFrameNames()) {
            if (this.alwaysAvailable.contains(e.toString())) continue;
            this.removeFrame(e.toString());
        }
    }

    public Set getAlwaysAvailable() {
        return this.alwaysAvailable;
    }
}

