/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideButton;
import commvault.cte.CteStringBank;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.Utilities;
import commvault.cte.component.calender.CalNavigationPanel;
import commvault.cte.component.calender.CalView;
import commvault.cte.component.calender.CalendarUtil;
import commvault.cte.component.calender.CalendarView;
import commvault.cte.component.calender.CalendarViewModel;
import commvault.cte.component.calender.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MonthlyCalView
extends CalView
implements AdjustmentListener {
    private int rowsInView = 6;

    public MonthlyCalView(CalendarViewModel calendarViewModel, CalendarView calendarView) {
        super(calendarViewModel, calendarView);
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        DayTaskRenderer dayTaskRenderer = new DayTaskRenderer(false);
        this.table.setDefaultRenderer(Object.class, dayTaskRenderer);
        this.table.setDefaultEditor(Object.class, new DayTaskRenderer(true));
        this.table.setRowHeight((calendarView.geView().getHeight() - 40) / this.rowsInView);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.scroll.getRowHeader().setPreferredSize(new Dimension(20, 10));
        jScrollBar.setBlockIncrement(1);
        this.scroll.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (MonthlyCalView.this.outlookView.isLoaded()) {
                    MonthlyCalView.this.adjustTableRowHeight();
                }
            }
        });
        this.table.getActionMap().put("selectNextRowCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthlyCalView.this.outlookView.setDailyView((Date)MonthlyCalView.this.table.getModel().getValueAt(MonthlyCalView.this.table.getSelectedRow(), MonthlyCalView.this.table.getSelectedColumn()));
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(34, 0), "scroll.pg.down");
        this.table.getActionMap().put("scroll.pg.down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthlyCalView.this.navigateRight();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(33, 0), "scroll.pg.up");
        this.table.getActionMap().put("scroll.pg.up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthlyCalView.this.navigateLeft();
            }
        });
        JideButton jideButton = new JideButton(" v ");
        jideButton.setBorderPainted(true);
        jideButton.setBorder(BorderFactory.createLineBorder(Color.black));
        JSeparator jSeparator = new JSeparator(0);
        this.currentView.getParent().add(jSeparator);
        this.currentView.getParent().add(Box.createHorizontalStrut(20));
        this.currentView.getParent().add((Component)jideButton);
        jideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
                JPanel jPanel = new JPanel(new GridBagLayout());
                final JDateChooser jDateChooser = new JDateChooser(MonthlyCalView.this.getFocusTime());
                LayoutUtils.addRow(jPanel, (JComponent)new JLabel(CteStringBank.Focus_Date.getI18n()), (JComponent)((Object)jDateChooser));
                final JNumericTextField jNumericTextField = new JNumericTextField("" + MonthlyCalView.this.rowsInView, new NumericDocument(2L, 10L));
                jNumericTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MonthlyCalView.this.rowsInView = jNumericTextField.getInt();
                        MonthlyCalView.this.adjustTableRowHeight();
                    }
                });
                jDateChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jDateChooser.getDateInMillis() <= new Date().getTime()) {
                            jDateChooser.setDate(MonthlyCalView.this.getFocusTime());
                            return;
                        }
                        MonthlyCalView.this.setFocusTime(jDateChooser.getDate());
                    }
                });
                LayoutUtils.addRow(jPanel, (JComponent)new JLabel(CteStringBank.Number_of_rows_in_view.getI18n()), (JComponent)jNumericTextField);
                final JCheckBox jCheckBox = new JCheckBox(CteStringBank.Show_Days_Details.getI18n());
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MonthlyCalView.this.showDaysDetails(jCheckBox.isSelected());
                    }
                });
                jidePopup.add((Component)jPanel);
                jidePopup.showPopup((Component)MonthlyCalView.this.currentView);
            }
        });
    }

    private void showDaysDetails(boolean bl) {
        JLayeredPane jLayeredPane = SwingUtilities.getRootPane(this).getLayeredPane();
        if (jLayeredPane.getLayout() == null) {
            jLayeredPane.setLayout(new BorderLayout(){

                @Override
                public void layoutContainer(Container container) {
                    super.layoutContainer(container);
                    Component component = this.getLayoutComponent(container, "South");
                    Point point = SwingUtilities.convertPoint(MonthlyCalView.this.table, MonthlyCalView.this.table.getVisibleRect().x, MonthlyCalView.this.table.getVisibleRect().y, container);
                    Rectangle rectangle = MonthlyCalView.this.table.getCellRect(0, MonthlyCalView.this.rowsInView - 1, true);
                    component.setBounds(point.x, point.y, MonthlyCalView.this.table.getVisibleRect().width, MonthlyCalView.this.table.getVisibleRect().height - rectangle.height);
                }
            });
            CalNavigationPanel calNavigationPanel = this.outlookView.createView(CalendarViewModel.CalendarType.DETAIL, false, null);
            calNavigationPanel.setFocusTime(this.getFromTime());
            calNavigationPanel.add((Component)new JLabel(""), "North");
            jLayeredPane.add((Component)calNavigationPanel, "South");
        }
    }

    @Override
    protected void handleTableEdit(int n, int n2, EventObject eventObject) {
        if (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2) {
            this.outlookView.setDailyView((Date)this.table.getModel().getValueAt(n, n2));
        }
    }

    protected void adjustTableRowHeight() {
        int n = this.scroll.getViewport().getHeight() / this.rowsInView;
        int n2 = Utilities.userDefinedFont == 0 ? n : (Utilities.userDefinedFont > 14 && Utilities.userDefinedFont <= 15 ? n + this.rowsInView * 6 : (n = Utilities.userDefinedFont >= 12 && Utilities.userDefinedFont <= 14 ? n + this.rowsInView * 5 : n));
        if (n < 1) {
            return;
        }
        this.table.setRowHeight(n);
        this.scroll.getVerticalScrollBar().setBlockIncrement(n);
        int n3 = this.table.rowAtPoint(this.scroll.getViewport().getViewPosition());
        Rectangle rectangle = this.table.getCellRect(n3, 0, true);
        rectangle.height = this.scroll.getViewport().getHeight();
        this.table.scrollRectToVisible(rectangle);
    }

    @Override
    protected void navigateLeft() {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
        if (boundedRangeModel.getValue() < jScrollBar.getBlockIncrement()) {
            Date date = CalendarUtil.getScrolledDateByWeek(this.getModel().getStartTime(), -this.rowsInView);
            Date date2 = this.createStartTime(new Date());
            date = new Date(Math.max(date2.getTime(), date.getTime()));
            this.getModel().setStartTime(date);
            this.getModel().fireTableDataChanged();
            this.ensureTasksLoaded();
        } else {
            boundedRangeModel.setValue(boundedRangeModel.getValue() - jScrollBar.getBlockIncrement() * this.rowsInView);
        }
    }

    @Override
    protected void navigateRight() {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
        if (boundedRangeModel.getValue() > boundedRangeModel.getMaximum() - jScrollBar.getBlockIncrement() * (this.rowsInView + 1)) {
            this.getModel().setStartTime(CalendarUtil.getScrolledDateByWeek(this.getModel().getStartTime(), this.rowsInView));
            this.getModel().fireTableDataChanged();
            this.ensureTasksLoaded();
        } else {
            boundedRangeModel.setValue(boundedRangeModel.getValue() + jScrollBar.getBlockIncrement() * this.rowsInView);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        int n = ToolTipManager.sharedInstance().getInitialDelay();
        jScrollBar.setToolTipText(DateFormat.getDateInstance().format(this.getFromTime()));
        ToolTipManager.sharedInstance().registerComponent(jScrollBar);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(jScrollBar, 1, 0L, 0, -100, jScrollBar.getSize().height / 2, 1, false, 0));
        ToolTipManager.sharedInstance().setInitialDelay(n);
        ToolTipManager.sharedInstance().unregisterComponent(jScrollBar);
        if (adjustmentEvent.getValueIsAdjusting()) {
            return;
        }
        this.synchroniseView();
    }

    private void synchroniseView() {
        BoundedRangeModel boundedRangeModel = this.scroll.getVerticalScrollBar().getModel();
        this.scroll.getVerticalScrollBar().removeAdjustmentListener(this);
        float f = (float)boundedRangeModel.getValue() * 1.0f / (float)boundedRangeModel.getMaximum() * (float)this.table.getRowCount();
        int n = (int)f;
        int n2 = (double)(f - (float)n) > 0.5 ? n + 1 : n;
        int n3 = n2 * boundedRangeModel.getMaximum() / this.table.getRowCount();
        this.scroll.getViewport().setViewPosition(new Point(0, n3));
        boundedRangeModel.setValue(n3);
        if (!this.isAdjestmentListenerExists()) {
            this.scroll.getVerticalScrollBar().addAdjustmentListener(this);
        }
        this.ensureTasksLoaded();
    }

    private void updateCurrentTime(JScrollBar jScrollBar) {
        int n = jScrollBar.getValue() / jScrollBar.getBlockIncrement();
        int n2 = (jScrollBar.getValue() + jScrollBar.getVisibleRect().height) / jScrollBar.getBlockIncrement();
        Date date = (Date)this.getModel().getValueAt(n, 0);
        Date date2 = (Date)this.getModel().getValueAt(n2 - 1, this.getModel().getColumnCount() - 1);
        this.currentView.setText(MessageFormat.format(CteStringBank.month_range.getI18n(), date, date2, date2));
    }

    @Override
    public Date getToTime() {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        int n = jScrollBar.getValue() / jScrollBar.getBlockIncrement();
        return (Date)this.getModel().getValueAt(Math.min(this.table.getRowCount() - 1, n + 7), this.table.getColumnCount() - 1);
    }

    @Override
    public Date getFromTime() {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        int n = jScrollBar.getValue() / jScrollBar.getBlockIncrement();
        return (Date)this.getModel().getValueAt(Math.max(n, 0), 0);
    }

    @Override
    protected Date createStartTime(Date date) {
        return CalendarUtil.getStartDateForMonthlyView(date);
    }

    boolean isAdjestmentListenerExists() {
        AdjustmentListener[] adjustmentListenerArray;
        for (AdjustmentListener adjustmentListener : adjustmentListenerArray = this.scroll.getVerticalScrollBar().getAdjustmentListeners()) {
            if (adjustmentListener != this) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setDataLoaded() {
        super.setDataLoaded();
        this.updateCurrentTime(this.scroll.getVerticalScrollBar());
    }

    @Override
    protected void loadData(Date date, Date date2) throws Exception {
        this.outlookView.ensureTasksLoaded(date, date2);
        if (!this.isAdjestmentListenerExists()) {
            this.scroll.getVerticalScrollBar().addAdjustmentListener(this);
        }
    }

    @Override
    public void refresh() {
        this.outlookView.refresh();
    }

    class DayTaskRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private JLabel editor = new JLabel(){

            @Override
            public String getToolTipText() {
                return MonthlyCalView.this.outlookView.getTooltipText(DayTaskRenderer.this.date);
            }
        };
        private JButton button = new JideButton();
        private boolean editing;
        private Date date;

        public DayTaskRenderer(boolean bl) {
            this.editing = bl;
            this.editor.setLayout(new BorderLayout(0, 0));
            this.editor.add((Component)this.button, "North");
            this.button.setFocusable(false);
            this.button.setOpaque(true);
            this.button.setHorizontalAlignment(2);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.editing ? MonthlyCalView.this.outlookView.getTaskRenderer().getMonthlyEditor(MonthlyCalView.this.outlookView, (Date)object) : MonthlyCalView.this.outlookView.getTaskRenderer().getMonthlyRenderer(MonthlyCalView.this.outlookView, (Date)object, bl);
            this.editor.add(component);
            this.date = (Date)object;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            int n3 = calendar.get(5);
            int n4 = jTable.rowAtPoint(jTable.getVisibleRect().getLocation());
            if (n3 == 1 || n4 == n && n2 == 0) {
                this.button.setText(MessageFormat.format("{0,date,MMM} {1}", object, n3));
                this.button.setFont(MonthlyCalView.this.getFont().deriveFont(1));
            } else {
                this.button.setText("" + calendar.get(5));
                this.button.setFont(MonthlyCalView.this.getFont().deriveFont(0));
            }
            if (calendar.get(6) == Calendar.getInstance().get(6)) {
                ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
                this.editor.setBorder(BorderFactory.createLineBorder(themePainter.getSelectionSelectedDk(), 3));
            } else {
                this.editor.setBorder(null);
            }
            return this.editor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return new DayTaskRenderer(true).getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.date;
        }
    }
}

