/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.SComboBox;
import commvault.cte.component.Utilities;
import commvault.cte.component.calender.ChangeTimeZoneInterface;
import commvault.cte.component.calender.PopupCalendar;
import commvault.cte.component.events.TimeListener;
import commvault.cte.util.DateUtilities;
import commvault.cte.util.RuntimeContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;

public final class CalendarComboBox
extends JPanel
implements KeyListener,
FocusListener,
ActionListener,
ChangeTimeZoneInterface {
    private static final String prefix = "cte.component.CalendarComboBox";
    public static final int HOURS = 20;
    public static final int MINS = 21;
    Calendar theday;
    PopupCalendar popupCalendar;
    SimpleDateFormat dateFormat2 = null;
    SimpleDateFormat dateFormat1 = null;
    public JTextArea comboBoxTextField;
    BasicArrowButton comboBoxButton = new BasicArrowButton(5);
    BevelBorder bBorder = new BevelBorder(1);
    Vector listeners = new Vector();
    private boolean directionCalculated;
    private int direction = 5;
    private boolean forceDirectionAdjustment = false;
    KeyEvent enterKeyEvent;
    KeyEvent ctrlRightKeyEvent;
    KeyEvent ctrlLeftKeyEvent;
    KeyEvent rightKeyEvent;
    KeyEvent leftKeyEvent;
    EventListenerList listenerList = new EventListenerList();
    ActionEvent actionEvent;
    private boolean isTimeResetToStartTime = false;

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (this.actionEvent == null) {
                this.actionEvent = new ActionEvent(this, 0, CteStringBank.Time_Changed.getI18n());
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(this.actionEvent);
        }
    }

    public CalendarComboBox() {
        this(false);
    }

    public CalendarComboBox(boolean bl) {
        this.isTimeResetToStartTime = bl;
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        this.theday = new GregorianCalendar(locale);
        if (this.isTimeResetToStartTime) {
            this.theday.set(11, 0);
            this.theday.set(12, 0);
            this.theday.set(13, 0);
        }
        this.init();
    }

    public CalendarComboBox(int n, int n2, int n3) {
        this.theday = new GregorianCalendar(n, n2, n3);
        this.init();
    }

    public CalendarComboBox(Calendar calendar) {
        this.theday = calendar;
        this.init();
    }

    public Calendar getDate() {
        return this.theday;
    }

    public boolean getUserInputTime() {
        String string = this.comboBoxTextField.getText();
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theday.getTimeZone(), locale);
        try {
            gregorianCalendar.setTime(this.dateFormat1.parse(string));
        }
        catch (ParseException parseException) {
            try {
                gregorianCalendar.setTime(this.dateFormat2.parse(string));
            }
            catch (ParseException parseException2) {
                Utilities.showErrorMessage(this, CteStringBank.Invalid_date_format.getI18n());
                this.comboBoxTextField.selectAll();
                return false;
            }
        }
        this.theday.set(1, gregorianCalendar.get(1));
        this.theday.set(2, gregorianCalendar.get(2));
        this.theday.set(5, gregorianCalendar.get(5));
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeListener)this.listeners.elementAt(i)).timeChanged(this.theday);
        }
        this.fireActionPerformed();
        return true;
    }

    private void init() {
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        this.dateFormat2 = new SimpleDateFormat(DateUtilities.instance().getUserSpecificShortDateFormat(), locale);
        this.dateFormat1 = new SimpleDateFormat(DateUtilities.instance().getUserSpecificShortDateFormat(), locale);
        this.comboBoxTextField = new JTextArea();
        this.comboBoxTextField.setFont(new JTextField().getFont());
        this.comboBoxTextField.setEditable(false);
        this.popupCalendar = new PopupCalendar(this, this.isTimeResetToStartTime);
        this.popupCalendar.comboBoxTextField.requestFocus();
        this.setLayout(new BorderLayout());
        this.add("Center", this.comboBoxTextField);
        this.add("East", this.comboBoxButton);
        this.comboBoxButton.addActionListener(this);
        this.comboBoxButton.setRequestFocusEnabled(true);
        this.comboBoxTextField.addFocusListener(this);
        this.comboBoxTextField.addKeyListener(this);
        this.enterKeyEvent = new KeyEvent(this.popupCalendar.popupTextArea, 402, 0L, 0, 10, '\n');
        this.ctrlRightKeyEvent = new KeyEvent(this.popupCalendar.popupTextArea, 402, 0L, 2, 39, '\'');
        this.ctrlLeftKeyEvent = new KeyEvent(this.popupCalendar.popupTextArea, 402, 0L, 2, 37, '%');
        this.rightKeyEvent = new KeyEvent(this.popupCalendar.popupTextArea, 402, 0L, 0, 39, '\'');
        this.leftKeyEvent = new KeyEvent(this.popupCalendar.popupTextArea, 402, 0L, 0, 37, '%');
        this.setBorder(new SComboBox().getBorder());
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.comboBoxTextField != null) {
            this.comboBoxTextField.setOpaque(bl);
        }
        if (this.comboBoxButton != null) {
            this.comboBoxButton.setOpaque(bl);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.directionCalculated && !this.displaySouthButton(this.popupCalendar)) {
            this.direction = 1;
            this.comboBoxButton.setDirection(1);
        }
        super.paint(graphics);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            if (keyEvent.getModifiers() == 2) {
                this.popupCalendar.popupTextArea.dispatchEvent(this.ctrlRightKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
            } else if (this.popupCalendar.popupTextArea.getSelectionEnd() + 1 >= this.popupCalendar.popupTextArea.getText().length()) {
                this.popupCalendar.popupTextArea.setSelectionStart(this.popupCalendar.popupTextArea.getSelectionEnd());
                this.popupCalendar.popupTextArea.dispatchEvent(this.rightKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
            } else {
                this.popupCalendar.popupTextArea.setSelectionStart(this.popupCalendar.popupTextArea.getSelectionEnd() + 1);
                this.popupCalendar.popupTextArea.dispatchEvent(this.rightKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
            }
        } else if (keyEvent.getKeyCode() == 38) {
            if (keyEvent.getModifiers() == 2) {
                this.popupCalendar.popupTextArea.dispatchEvent(this.ctrlLeftKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
                this.popupCalendar.popupTextArea.requestFocus();
            } else if (this.popupCalendar.popupTextArea.getSelectionEnd() - 2 <= 0) {
                this.popupCalendar.popupTextArea.setSelectionStart(this.popupCalendar.popupTextArea.getSelectionEnd());
                this.popupCalendar.popupTextArea.dispatchEvent(this.leftKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
            } else {
                this.popupCalendar.popupTextArea.dispatchEvent(this.leftKeyEvent);
                this.popupCalendar.popupTextArea.dispatchEvent(this.enterKeyEvent);
            }
        }
        if (keyEvent.getKeyCode() == 40 && keyEvent.getModifiers() == 8) {
            this.setPopupVisible();
        } else if (this.direction == 1 && keyEvent.getKeyCode() == 38 && keyEvent.getModifiers() == 8) {
            this.setPopupVisible();
        }
        if (keyEvent.getKeyCode() == 10) {
            this.getUserInputTime();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setPopupVisible() {
        if (!this.comboBoxButton.isEnabled()) {
            return;
        }
        if (this.popupCalendar.isShowing()) {
            this.popupCalendar.setVisible(false);
        } else {
            this.popupCalendar.popupTextArea_setFocus();
            DummyComponent dummyComponent = new DummyComponent(this.getParent());
            dummyComponent.setLocationOnScreen(this.getPopupLocation(this.popupCalendar));
            this.popupCalendar.show(dummyComponent, 0, 0);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.comboBoxTextField) {
            this.comboBoxTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void setEnabled(boolean bl) {
        this.comboBoxTextField.setEnabled(bl);
        this.comboBoxButton.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBoxButton.isEnabled();
    }

    public Calendar getOnlyDateTime() {
        Calendar calendar = this.getTime();
        calendar.set(11, 0);
        calendar.set(12, 0);
        return calendar;
    }

    public Calendar getTime() {
        Calendar calendar = null;
        if (this.getUserInputTime()) {
            calendar = this.theday;
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public void setTime(Calendar calendar) {
        this.theday = calendar;
        this.dateFormat1.setTimeZone(this.theday.getTimeZone());
        this.popupCalendar.setTime(calendar);
        this.comboBoxTextField.setText(this.dateFormat1.format(this.theday.getTime()));
    }

    public void addTimeListener(TimeListener timeListener) {
        if (timeListener != null) {
            this.listeners.add(timeListener);
            this.popupCalendar.addTimeListener(timeListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.comboBoxButton) {
            this.setPopupVisible();
        }
    }

    private boolean displaySouthButton(PopupCalendar popupCalendar) {
        this.directionCalculated = true;
        Dialog dialog = this.getDialog();
        if (!(this.forceDirectionAdjustment || dialog != null && dialog.isModal())) {
            return true;
        }
        Point point = this.comboBoxTextField.getLocationOnScreen();
        Dimension dimension = this.comboBoxTextField.getPreferredSize();
        dimension.width = this.comboBoxButton.getPreferredSize().width + this.comboBoxButton.getLocationOnScreen().x - this.comboBoxTextField.getLocationOnScreen().x;
        Dimension dimension2 = popupCalendar.getPreferredSize();
        Rectangle rectangle = dialog.getBounds();
        rectangle.x = dialog.getLocationOnScreen().x;
        rectangle.y = dialog.getLocationOnScreen().y;
        Rectangle rectangle2 = new Rectangle(0, 0, (int)dimension2.getWidth(), (int)dimension2.getHeight());
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.y += (int)dimension.getHeight();
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return true;
        }
        if (dimension2.width > dimension.width) {
            rectangle2.x = point.x;
            rectangle2.y = point.y;
            rectangle2.y += (int)dimension.getHeight();
            rectangle2.x -= Math.abs(dimension2.width - dimension.width);
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
                return true;
            }
        }
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.y -= (int)dimension2.getHeight();
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return false;
        }
        if (dimension2.width > dimension.width) {
            rectangle2.x -= Math.abs(dimension2.width - dimension.width);
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
                return false;
            }
        }
        return true;
    }

    private Point getPopupLocation(PopupCalendar popupCalendar) {
        Dialog dialog = this.getDialog();
        Point point = this.comboBoxTextField.getLocationOnScreen();
        Dimension dimension = this.comboBoxTextField.getPreferredSize();
        dimension.width = this.comboBoxButton.getPreferredSize().width + this.comboBoxButton.getLocationOnScreen().x - this.comboBoxTextField.getLocationOnScreen().x;
        if (!(this.forceDirectionAdjustment || dialog != null && dialog.isModal())) {
            point.y += dimension.height;
            return point;
        }
        Dimension dimension2 = popupCalendar.getPreferredSize();
        Rectangle rectangle = dialog.getBounds();
        rectangle.x = dialog.getLocationOnScreen().x;
        rectangle.y = dialog.getLocationOnScreen().y;
        Rectangle rectangle2 = new Rectangle(0, 0, (int)dimension2.getWidth(), (int)dimension2.getHeight());
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.y += (int)dimension.getHeight();
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            point.y += dimension.height + 1;
            return point;
        }
        if (dimension2.width > dimension.width) {
            rectangle2.x = point.x;
            rectangle2.y = point.y;
            rectangle2.y += (int)dimension.getHeight();
            rectangle2.x -= Math.abs(dimension2.width - dimension.width);
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
                return new Point(rectangle2.x, rectangle2.y);
            }
        }
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.y -= (int)dimension2.getHeight();
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return new Point(rectangle2.x, rectangle2.y);
        }
        if (dimension2.width > dimension.width) {
            rectangle2.x -= Math.abs(dimension2.width - dimension.width);
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
                return new Point(rectangle2.x, rectangle2.y);
            }
        }
        return point;
    }

    private Dialog getDialog() {
        Container container;
        for (container = this.comboBoxTextField.getParent(); container != null && !(container instanceof Dialog) && !(container instanceof Window); container = container.getParent()) {
        }
        if (container instanceof Dialog) {
            return (Dialog)container;
        }
        return null;
    }

    public static String getDateTime(Calendar calendar) {
        return MessageFormat.format(CteStringBank.cte_component_CalendarComboBox_datatime.getI18n(), CalendarComboBox.getDate(calendar), CalendarComboBox.getTime(calendar));
    }

    public static String getDate(Calendar calendar) {
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtilities.instance().getUserSpecificLongDateFormat(), locale);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getTime(Calendar calendar) {
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtilities.instance().getUserSpecificLongTimeFormat(), locale);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static int getSeconds(Calendar calendar) {
        int n = 0;
        if (calendar != null) {
            calendar.set(13, 0);
            n = (int)(calendar.getTime().getTime() / 1000L);
        }
        return n;
    }

    public static int getSecondsFromMidnight(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        return n * 60 * 60 + n2 * 60;
    }

    public static int getSeconds(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string);
            if (n == 20) {
                n2 = n3 * 60 * 60;
            } else if (n == 21) {
                n2 = n3 * 60;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static int getSeconds(int n, int n2) {
        int n3 = 0;
        if (n2 == 20) {
            n3 = n * 60 * 60;
        } else if (n2 == 21) {
            n3 = n * 60;
        }
        return n3;
    }

    public static int getHours(int n) {
        int n2 = 0;
        n2 = n / 3600;
        return n2;
    }

    public static int getMins(int n) {
        int n2 = 0;
        n2 = n % 3600 / 60;
        return n2;
    }

    public static Calendar getCalendarTime(int n) {
        Date date = new Date((long)n * 1000L);
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static Calendar getCalendarTime(GregorianCalendar gregorianCalendar, int n) {
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), CalendarComboBox.getHours(n), CalendarComboBox.getMins(n));
        return Calendar.getInstance(locale);
    }

    @Override
    public void requestFocus() {
        this.comboBoxTextField.requestFocus();
    }

    public int getUnixTime() {
        return (int)(this.getTime().getTime().getTime() / 1000L);
    }

    public int getNextDaysUnixTime() {
        Calendar calendar = this.getOnlyDateTime();
        calendar.add(5, 1);
        return (int)(calendar.getTime().getTime() / 1000L);
    }

    public void setTime(long l) {
        Date date = new Date(l * 1000L);
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theday.getTimeZone(), locale);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public void setTime(int n) {
        Date date = new Date((long)n * 1000L);
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theday.getTimeZone(), locale);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public void setTime(long l, TimeZone timeZone) {
        Date date = new Date(l * 1000L);
        Locale locale = RuntimeContext.instance().getLoggedInLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public void setForceDirectionAdjustment(boolean bl) {
        this.forceDirectionAdjustment = bl;
    }

    public boolean getForceDirectionAdjustment() {
        return this.forceDirectionAdjustment;
    }

    public int getUnixTimeSetToZero() {
        Date date = new Date((long)this.getUnixTime() * 1000L);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return (int)(gregorianCalendar.getTime().getTime() / 1000L);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.getUserInputTime();
        long l = this.theday.getTime().getTime();
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        Date date = new Date(l);
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
    }

    public PopupCalendar getPopupCalendar() {
        return this.popupCalendar;
    }

    class DummyComponent
    extends JComponent {
        Point location = null;
        Container c = null;

        public DummyComponent(Container container) {
            this.c = container;
        }

        public void setLocationOnScreen(Point point) {
            this.location = point;
        }

        @Override
        public Point getLocationOnScreen() {
            if (this.location == null) {
                this.location = new Point(0, 0);
            }
            return this.location;
        }

        @Override
        public Container getParent() {
            return this.c;
        }
    }
}

