/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.SComboBox;
import commvault.cte.component.calender.CalendarComboBox;
import commvault.cte.component.events.TimeListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CalendarChooserPanel
extends JPanel
implements ActionListener {
    Calendar g = null;
    boolean initiatedEvent = false;
    public static int MONTH_YEAR = 10;
    public static int DAY_MONTH_YEAR = 11;
    CalendarComboBox calendarComboBox = null;
    SComboBox monthComboBox = null;
    JNumericTextField yearSpinner = null;
    private int currentViewType;
    private boolean isEnabled = true;
    private static String[] months = new String[]{CteStringBank.January.getI18n(), CteStringBank.February.getI18n(), CteStringBank.March.getI18n(), CteStringBank.April.getI18n(), CteStringBank.May.getI18n(), CteStringBank.June.getI18n(), CteStringBank.July.getI18n(), CteStringBank.August.getI18n(), CteStringBank.September.getI18n(), CteStringBank.October.getI18n(), CteStringBank.November.getI18n(), CteStringBank.December.getI18n()};
    private Vector listeners = new Vector();

    public CalendarChooserPanel() {
        this(new GregorianCalendar());
    }

    public CalendarChooserPanel(int n, int n2, int n3) {
        this(new GregorianCalendar(n, n2, n3));
    }

    public CalendarChooserPanel(GregorianCalendar gregorianCalendar) {
        this.g = gregorianCalendar;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.calendarComboBox = new CalendarComboBox(this.g);
        this.monthComboBox = new SComboBox(months, false);
        this.yearSpinner = new JNumericTextField(String.valueOf(this.g.get(1)), new NumericDocument(this.g.getMinimum(1), this.g.getMaximum(1)));
        this.yearSpinner.setEditable(false);
        this.yearSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.yearSpinner.setPreferredSize(new Dimension(60, 23));
        this.monthComboBox.setPreferredSize(new Dimension(120, 23));
        this.calendarComboBox.setPreferredSize(new Dimension(120, 23));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setView(MONTH_YEAR);
        this.monthComboBox.addActionListener(this);
        this.yearSpinner.addActionListener(this);
        this.setTime(this.g);
    }

    public void setView(int n) {
        if (n == this.currentViewType) {
            return;
        }
        this.currentViewType = n;
        this.removeAll();
        if (this.currentViewType == DAY_MONTH_YEAR) {
            this.add(this.calendarComboBox);
        } else if (this.currentViewType == MONTH_YEAR) {
            this.add(this.monthComboBox);
            this.add(this.yearSpinner);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.calendarComboBox.setEnabled(this.isEnabled);
        this.monthComboBox.setEnabled(this.isEnabled);
        this.yearSpinner.setEnabled(this.isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Calendar getTime() {
        if (this.currentViewType == MONTH_YEAR) {
            this.g.set(2, this.monthComboBox.getSelectedIndex());
            this.g.set(1, Integer.parseInt(this.yearSpinner.getText()));
            this.g.set(5, 1);
            this.g.set(11, 0);
            this.g.set(12, 0);
            this.g.set(13, 0);
        } else {
            this.g = this.calendarComboBox.getTime();
        }
        return this.g;
    }

    public void setTime(Calendar calendar) {
        this.initiatedEvent = true;
        this.g = calendar;
        this.calendarComboBox.setTime(this.g);
        this.yearSpinner.setText(String.valueOf(this.g.get(1)));
        this.monthComboBox.setSelectedIndex(this.g.get(2));
        this.initiatedEvent = false;
    }

    public void addTimeListener(TimeListener timeListener) {
        if (timeListener != null) {
            this.listeners.add(timeListener);
            this.calendarComboBox.addTimeListener(timeListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.triggerTimeChangedEvent();
    }

    public void triggerTimeChangedEvent() {
        if (this.initiatedEvent) {
            return;
        }
        Calendar calendar = this.getTime();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeListener)this.listeners.elementAt(i)).timeChanged(calendar);
        }
    }
}

